#!/usr/bin/env bash

# Provides: reload_config_status

die() {
    echo "PASSIVE-CHECK:reload_config_status;$1;$2"
    exit 0
}

dir="/place/db/www/logs/balancer"
status_file="reload_config.log"
test -d "${dir}" || die 0 "Directory with status file doesn't exist"
test -e "${dir}/${status_file}" || die 0 "Status file doesn't exist"
declare -a problem_configs

while read line; do
    if echo "${line}" | grep -q ERROR; then
        cfg=$(echo "${line}" | awk '{print $4}')
        problem_configs+=( "${cfg}" )
    fi
done < "${dir}/${status_file}"

if [ ${#problem_configs[@]} -gt 0 ]; then
    die 2 "Not properly reloaded configs: $(echo "${problem_configs[@]}")"
fi

die 0 "Everything is OK"
