#! /usr/bin/env python
# coding: utf8

# Provides: uaas_exp_state

from lxml import etree
import os
import requests
import sys


def die(status, message):
    print 'PASSIVE-CHECK:uaas_exp_state;{};{}'.format(status, message)
    sys.exit(0)


def get_state(config_type, service_port):
    """return dict with keys:
        - 'status'
        - 'message'"""

    URL = 'http://127.0.0.1:{}/admin/events/xmlwrapcall/{}'.format(
        service_port,
        config_type
    )
    try:
        result = requests.get(URL).text
    except requests.exceptions.ConnectionError:
        return {'status': 1, 'message': 'uaas balancer unreachable'}
    except Exception as err:
        return {'status': 1, 'message': '{}'.format(err)}

    data = dict()

    tree = etree.fromstring(result)
    nodes = tree.xpath('/xml/exp')
    for node in nodes:
        for item in node:
            item_tag = item.tag
            item_text = item.text
            if item.tag == 'exp_config_hunter_cont':
                item_tag = 'last_error'
                item_text = item.find('./capture_config/last_error').text

            data.setdefault(item_tag, set()).add(item_text)

    # See doc https://wiki.yandex-team.ru/JandeksPoisk/Sepe/balancer/Cookbook/expdoc/

    error_table = {
        '0': 'OK',
        '1': 'config load error',
        '2': 'exception during parse of config',
        '3': 'incorrect config file',
    }

    status = max(data['exp_hibernation_level'])
    return {
        'status': int(status),
        'message': 'module for "{config_type}" in HL "{hl}" state due to {last_err}'.format(
            config_type=config_type,
            hl=status,
            last_err=error_table[max(data['last_error'])],
        )
    }


def main():
    result = []
    config_types = (
        'production',
        'testing',
    )
    service_port = os.getenv('SERVICE_PORT', 15480)
    for config_type in config_types:
        result.append(get_state(config_type, service_port))

    status_for_die = max(r['status'] for r in result)
    message_for_die = '; '.join(r['message'] for r in result)

    die(status_for_die, message_for_die)


if __name__ == '__main__':
    main()
