'''
simtool make-snapshot <dc> --node-segment default --output ~/arcadia/infra/rtc/analytics/RTCANALYTICS-229/snapshots/<dc>.json
cd ~/arcadia/infra/rtc/analytics/RTCANALYTICS-229
'''


from datetime import date, timedelta
import json
import os
import subprocess
from yql.api.v1.client import YqlClient
import yt.wrapper as yt


def get_fqdn_id(fqdns):
    input = ' '.join(fqdns)
    command = 'ya tool wall-e -b hosts list-only -C inv,name'
    output = subprocess.run(command, shell=True, input=input, stdout=subprocess.PIPE, encoding='utf-8').stdout
    return output


def get_table(client):
    today = str(date.today() - timedelta(days=1))
    table = {}

    query = '''
    SELECT `instance_number`, `hdd_num` FROM hahn.`//home/haas/cmis/hw_power_by_components_v2/{}`
    '''.format(today)

    request = client.query(
        query,
        syntax_version=1
    )
    request.run()
    request.get_results()

    for T in request.get_results():
        T.fetch_full_data()
        for row in T.rows:
            id, num = row[0], row[1]
            if num is None:
                num = 0
            table[id] = num

    return table


def json_to_dict():
    with open('snapshots/{}.json'.format(dc), 'r') as snap:
        data = json.load(snap)
        snap.close()
        return data


def dict_to_json(data):
    os.system("touch modified_snapshots/{}.json".format(dc))

    with open('modified_snapshots/{}.json'.format(dc), 'w') as snap:
        json.dump(data, snap)
        snap.close()
    print('modified snapshot created')


def main():
    yt.config.set_proxy("hahn")
    client = YqlClient(db="hahn")
    table = get_table(client)
    print('yt table received')

    data = json_to_dict()
    print('json data received')

    fqdns = set()
    index = {}
    for i in range(len(data['resources'])):
        record = data['resources'][i]
        if record['meta']['kind'] == 'disk' and record['spec']['disk']['storage_class'] == 'hdd' and record['spec']['disk']['device'] == '/place':
            fqdn = record['meta']['node_id']
            index[fqdn] = i
            fqdns.add(fqdn)
    print(len(fqdns), 'fqdns received')

    output = get_fqdn_id(fqdns).split('\n')
    print('wall-e output received')

    ids = {}
    for out in output:
        id = out[:out.find(' ')]
        fqdn = out[out.find(' ') + 1:]
        if id != '':
            ids[fqdn] = id
    print(len(ids), 'fqdn ids received')

    count = 0
    for fqdn in fqdns:
        if fqdn not in ids:
            print(fqdn, '-- no id')
            continue
        id = ids[fqdn]
        if id not in table:
            print(fqdn, '-- id is not in table')
            continue
        hdd_num = table[id]
        if hdd_num < 4 or hdd_num < hdd_num_left:
            continue
        i = index[fqdn]
        bandwidth = 0
        capacity = 0
        for pod in data['resources'][i]['status']['scheduled_allocations']:
            bandwidth += pod['disk']['bandwidth']
            capacity += pod['disk']['capacity']
        if bandwidth > data['resources'][i]['spec']['disk']['total_bandwidth'] or capacity > data['resources'][i]['spec']['disk']['total_capacity']:
            print(fqdn, '-- overcommit')
            continue
        data['resources'][i]['spec']['disk']['total_bandwidth'] = round(data['resources'][i]['spec']['disk']['total_bandwidth'] * hdd_num_left / hdd_num)
        data['resources'][i]['spec']['disk']['total_capacity'] = round(data['resources'][i]['spec']['disk']['total_capacity'] * hdd_num_left / hdd_num)
        data['resources'][i]['status']['free']['disk']['bandwidth'] = data['resources'][i]['spec']['disk']['total_bandwidth']
        data['resources'][i]['status']['free']['disk']['capacity'] = data['resources'][i]['spec']['disk']['total_capacity']
        data['resources'][i]['status']['free']['disk']['volume_slots'] = data['resources'][i]['spec']['disk']['total_volume_slots']
        data['resources'][i]['status']['used']['disk']['bandwidth'] = 0
        data['resources'][i]['status']['used']['disk']['capacity'] = 0
        data['resources'][i]['status']['used']['disk']['volume_slots'] = 0
        count += 1
    print(count, 'fqdns data modified')

    dict_to_json(data)
    print('done!')


if __name__ == "__main__":
    dc = 'sas'
    hdd_num_left = 2
    main()


'''
simtool run --experiment default --snapshot ~/arcadia/infra/rtc/analytics/RTCANALYTICS-229/modified_snapshots/<dc>.json
'''
