
import requests
from pprint import pprint


def get_all_rtc_servicenames():
    workplace_base = "https://workplace.z.yandex-team.ru/api/workplace.services.CatalogService/listRecords"
    payload = {"vertical": ["rtc"]}
    return set([i["service"] for i in requests.post(workplace_base, json=payload).json()["objects"]])


def get_verical_mapping():
    workplace_base = "https://workplace.z.yandex-team.ru/api/workplace.services.CatalogService/listRecords"
    payload = {}
    vertical_mapping = {}

    result = requests.post(workplace_base, json=payload).json()["objects"]

    for el in result:
        service = el.get("service")

        if service:
            vertical = el.get("vertical", "")
            vertical_mapping[service] = vertical

    return vertical_mapping

    # print("this {0} belongs to this {1}".format(el["service"], el["vertical"]))

    # pprint(result[0])


if __name__ == '__main__':
    pprint(get_verical_mapping())
