
import json
import os
import nirvana.job_context as nv


def process_new_format_json(input_data):

    new_format = {}

    for record in input_data:
        if record["product"] not in new_format:
            new_format[record["product"]] = {
                "assignee": record["assignee"],
                "link": record["link"],
                "product": record["product"],
                "status": record["status"],
                "status_str": record["status_str"],
                "tasks_count": record["tasks_count"]
            }
        else:
            new_format[record["product"]]["tasks_count"] += record["tasks_count"]

    for record in new_format.values():
        record["status_str"] = str(record["tasks_count"]) + " " + " ".join(record["status_str"].split(" ")[1::])

    return [i for i in new_format.values()]


if __name__ == '__main__':
    job_context = nv.context()
    inputs, outputs = job_context.get_inputs(), job_context.get_outputs()

    data = json.load(open(inputs.get(os.environ.get("INPUT_FILENAME"))))
    processed_data = process_new_format_json(data)

    filename = os.environ.get("OUTPUT_FILENAME")
    with open(outputs.get(filename), "w") as write_file:
        json.dump(processed_data, write_file)
