import json
import time

def safe_div(x, y):
    if y == 0:
        return 0.0
    return x / y


def aggregate_week_ago(rows):
    week_ago = time.strftime("%Y-%m-%d", time.localtime(time.time() - 8 * 24 * 60 * 60))
    res_pre = {}
    for row in rows:
        date = time.strftime("%Y-%m-%d", time.strptime(row["time"], "%Y-%m-%d %H:%M:%S"))
        if date <= week_ago:
            walle = row["walle_project"]
            key = walle + "~" + date
            if key not in res_pre:
                res_pre[key] = {
                    "unavailable_hosts": [row["unavailable_hosts"]],
                    "total_hosts": row["total_hosts"]
                }
            else:
                res_pre[key]["unavailable_hosts"].append(row["unavailable_hosts"])

    res = []
    for key, aggreg in res_pre.items():
        avg = sum(aggreg["unavailable_hosts"]) / len(aggreg["unavailable_hosts"])
        spl = key.split("~")
        res.append({
            "unavailable_hosts": avg,
            "total_hosts": aggreg["total_hosts"],
            "unavailable_rate": safe_div(avg, aggreg["total_hosts"]),
            "walle_project": spl[0],
            "date": spl[1]
        })
    return res
    

json.dump(aggregate_week_ago(json.load(open("input.json", "r"))), open("res.json", "w"), indent = 4)
