import json
import time
import argparse

import infra.analytics.io_limits_pipeline.utils as utils
import nirvana.job_context as nv
from yp.client import YpClient

from infra.rtc.analytics.gpu_metrics_collect.utils import get_gpu_projects, get_hosts_and_status, get_gpu_model, \
    safe_div, YP_CLIENTS, get_host_dc_walle


def collect(file1, file2):
    unavailability = []
    gpu_slice = []
    timestmp = time.strftime("%Y-%m-%d %H:minutes_here:00", time.localtime())
    mins = time.strftime("%M", time.localtime())
    timestmp = timestmp.replace("minutes_here", "30" if int(mins) >= 30 else "00")

    for prj in get_gpu_projects():
        host_counters = {}
        total_hosts = 0
        unavailable_hosts = 0

        host_statuses = get_hosts_and_status(prj)

        for host, status in host_statuses:

            client = YP_CLIENTS.get(host[0:3])

            if not client:
                client = YpClient(get_host_dc_walle(host), config=dict(token=utils.get_oauth_token()))

            try:
                gpu = get_gpu_model(host, client)

                if gpu == "":
                    unavailable_hosts += 1
                    total_hosts += 1
                    continue

                if gpu not in host_counters:
                    host_counters[gpu] = {
                        "total": 0,
                        "unavailable": 0
                    }
                host_counters[gpu]["total"] += 1
                total_hosts += 1
                if status != "ready":
                    unavailable_hosts += 1
                    host_counters[gpu]["unavailable"] += 1
            except:
                print("failed to get gpu {0}".format(host))
                raise

        unavailability.append({
            "walle_project": prj,
            "unavailable_hosts": unavailable_hosts,
            "total_hosts": total_hosts,
            "unavailable_rate": safe_div(unavailable_hosts, total_hosts),
            "time": timestmp
        })
        gpu_slice += [{
            "walle_project": prj,
            "gpu": gpu,
            "total_hosts": count["total"],
            "unavailable_hosts": count["unavailable"],
        } for gpu, count in host_counters.items()]
    json.dump(unavailability, file1, indent=4)
    json.dump(gpu_slice, file2, indent=4)


if __name__ == "__main__":
    utils.read_token()
    parser = argparse.ArgumentParser()
    parser.add_argument("--local_run", type=utils.str2bool, default=False)
    args = parser.parse_args()

    if args.local_run:
        output_file_1 = open("output1.json", "w")
        output_file_2 = open("output2.json", "w")
    else:
        job_context = nv.context()
        inputs = job_context.get_inputs()
        outputs = job_context.get_outputs()
        output_file_1 = open(outputs.get("output1"), "w")
        output_file_2 = open(outputs.get("output2"), "w")

    collect(output_file_1, output_file_2)
