import json
import time
import argparse

from infra.yasm.yasmapi import GolovanRequest
import infra.analytics.io_limits_pipeline.utils as utils
import nirvana.job_context as nv
from yp.client import YpClient

from infra.rtc.analytics.gpu_metrics_collect.utils import get_gpu_projects, get_hosts_and_status, get_gpu_model, \
    func_with_retry, YP_CLIENTS, get_host_dc_walle

signals = ["push-gpustat-utilization_gpu_tvvv", "push-gpustat-utilization_memory_tvvv"]

base_signal = "itype=runtimecloud:aver({1})"


def get_signals(host, prj, gpu):
    period = 3600
    et = int(time.mktime(time.strptime(time.strftime("%Y %m %d"), "%Y %m %d"))) - period # вчерашняя дата 23:00:00
    st = int(et) - 23 * period # вчерашняя дата 00:00:00 - собираем данные за вчерашний день
    full_signals = [base_signal.format(gpu, v) for v in signals]
    counter = 0

    req = iter(GolovanRequest(host, period, st, et, full_signals, connect_timeout = 300))

    while True:
        try:
            timestamp, collection = func_with_retry(lambda: next(req))
        except StopIteration:
            break
        for sig, val in collection.items():
            yield {
                "fqdn": host,
                "walle_project": prj,
                "gpu_model": gpu,
                "signal": sig[sig.find("aver(")+len("aver("):sig.rfind(")")],
                "timestamp": time.strftime("%Y-%m-%d %H:%M:%S", time.localtime(int(timestamp))),
                "value": float(val or 0)
            }


def collect(file1):
    metrics = []
    for prj in get_gpu_projects():
        for host, _ in get_hosts_and_status(prj):
            client = YP_CLIENTS.get(host[0:3])

            if not client:
                client = YpClient(get_host_dc_walle(host), config=dict(token=utils.get_oauth_token()))

            gpu = get_gpu_model(host, client)
            if gpu != "":
                for entry in get_signals(host, prj, gpu):
                    metrics.append(entry)
    json.dump(metrics, file1, indent=4)


if __name__ == "__main__":
    utils.read_token()
    parser = argparse.ArgumentParser()
    parser.add_argument("--local_run", type=utils.str2bool, default=False)
    args = parser.parse_args()

    if args.local_run:
        output_file_1 = open("output1.json", "w")
    else:
        job_context = nv.context()
        inputs = job_context.get_inputs()
        outputs = job_context.get_outputs()
        output_file_1 = open(outputs.get("output1"), "w")

    collect(output_file_1)
