import requests
import time
from yp.client import YpClient
import infra.analytics.io_limits_pipeline.utils as utils

base_url = "https://api.wall-e.yandex-team.ru/v1/hosts?project={0}&limit=10000"

MAX_TRIES = 5


def safe_div(x, y):
    if y == 0:
        return 0.0
    return x / y


YP_CLIENTS = {
    "iva": YpClient("iva", config=dict(token=utils.get_oauth_token())),
    "vla": YpClient("vla", config=dict(token=utils.get_oauth_token())),
    "man": YpClient("man", config=dict(token=utils.get_oauth_token())),
    "sas": YpClient("sas", config=dict(token=utils.get_oauth_token())),
    "myt": YpClient("myt", config=dict(token=utils.get_oauth_token()))

}


def get_host_dc_walle(host):
    try:
        return requests.get("https://api.wall-e.yandex-team.ru/v1/hosts/{0}?fields=location.short_datacenter_name".
                            format(host)).json()["location"]["short_datacenter_name"]
    except:
        return ""


def func_with_retry(func):
    for _ in range(MAX_TRIES - 1):
        try:
            return func()
        except StopIteration:
            raise
        except:
            time.sleep(30)
    return func()


def get_gpu_projects():
    prjs_url = "https://api.wall-e.yandex-team.ru/v1/projects"
    res = func_with_retry(lambda: requests.get(prjs_url)).json()["result"]
    for prj in res:
        req = func_with_retry(lambda: requests.get(prjs_url + "/" + prj["id"])).json()
        if "tags" in req and "rtc.gpu-nvidia" in req["tags"]:
            yield prj["id"]


def get_hosts_and_status(prj):
    # res = func_with_retry(lambda: requests.get(base_url.format(prj))).json()["result"]
    res = requests.get(base_url.format(prj)).json()["result"]
    for entry in res:
        yield entry["name"], entry["status"]


def get_gpu_model(host, client):
    get = func_with_retry(lambda: client.select_objects(
        "resource",
        selectors=["/spec/gpu/model"],
        filter="[/meta/kind]='gpu' and [/meta/node_id]='{0}'".format(host))
    )
    if len(get) == 0:
        print("unable to get GPU model for host {0}".format(host))
        return ""
    return get[0][0]
