import requests
from requests.exceptions import ConnectionError
from infra.rtc.analytics.hosts_counter.walle_model import compute_walle_stat
import json
import time
import datetime
import argparse
import os
import nirvana.job_context as nv


TABLE_PATH = "//home/runtimecloud/rtc_host_count/totals"

EXCLUDED_WALLE_TAGS = {
    "yt-hahn", "yt-freud", "yt-hahn-mtn", "yt-hahn-nirvana", "yt-hahn-upgrade", "yt-locke", "yt-ofd", "yt-ofd-myt",
    "yt-vanga"
}


def calculate_projects(walle_ids):
    base_url, totals = "https://api.wall-e.yandex-team.ru/v1/hosts", 0

    for id in walle_ids:
        url_to_chech = base_url + "?project=" + id
        try:
            totals += requests.get(url_to_chech).json()["total"]
        except ConnectionError:
            time.sleep(12)
            totals += requests.get(url_to_chech).json()["total"]

    return totals


def str2bool(v):
    if isinstance(v, bool):
        return v
    if v.lower() in ('yes', 'true', 't', 'y', '1'):
        return True
    elif v.lower() in ('no', 'false', 'f', 'n', '0'):
        return False
    else:
        raise argparse.ArgumentTypeError('Boolean value expected.')


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("--local_run", type=str2bool, default=False)
    args = parser.parse_args()

    fmt = "%Y-%m-%d"
    wlle_ids = list(compute_walle_stat().project_map.keys())

    total_prjcts = calculate_projects(wlle_ids)
    if args.local_run is True:
        with open("output.json", "w") as filename:
            json.dump([{"total_count": total_prjcts, "datetime": datetime.datetime.today().strftime(fmt)}], filename)
    else:
        job_context = nv.context()
        outputs = job_context.get_outputs()
        filename = os.environ.get("OUTPUT_FILE")
        with open(outputs.get(filename), "w") as write_file:
            json.dump([{"total_count": total_prjcts, "datetime": datetime.datetime.today().strftime(fmt)}], write_file)


if __name__ == '__main__':
    main()
