#!/usr/bin/env python
# encoding: utf-8
from startrek_client import Startrek
import nirvana.job_context as nv
import dateutil.parser
import requests
import json
import os
from os.path import realpath, join
import argparse
from time import sleep

CERT_PATH = realpath(join(__file__, '../allCAs.pem'))  # Скачать можно здесь "https://crls.yandex.net/allCAs.pem"


class CredentialNotFound(Exception):
    pass


def choose_credential(value, envvar, path):
    """
    Выбирает аутентификационные данные, в порядке приоритета:
         либо явно заданные,
         либо из переменной окружения,
         либо из заданного файла
    :param str value: Заданное пользователем значение
    :param str envvar: Переменная окружения, в которую может быть записано значение
    :param str path: Путь, в котором может лежать значение
    :rtype: str
    :return: Выбранное значение
    """
    if value is None:
        value = os.getenv(envvar)  # В нирвана операциях используется так

    path = os.path.expanduser(path)
    if value is None and os.path.exists(path):
        value = open(path).read().strip()  # Можно использовать для локальных тестов

    if value is None:
        msg = 'credential not found in "{}" nor "{}"'.format(envvar, path)
        raise CredentialNotFound(msg)
    else:
        return value


def make_oauth_header(token, envvar, path, content_type="application/json; charset=utf-8"):
    # Словарь хэдеров, для аутентификации через http oauth
    token = choose_credential(token, envvar, path)
    return {"Content-Type": content_type,
            "Authorization": "OAuth {}".format(token)}


def find_users(dep_name, token):
    users = set()
    gr_adr = "https://staff-api.yandex-team.ru/v3/persons?department_group.url=" + dep_name
    gr_req = requests.get(gr_adr, headers={'Authorization': "OAuth " + token})
    gr_staff = gr_req.json()
    users |= set([person['login'] for person in gr_staff['result']])

    sub_adr = "https://staff-api.yandex-team.ru/v3/groups?parent.url=" + dep_name
    sub_req = requests.get(sub_adr, headers={'Authorization': "OAuth " + token})
    sub_staff = sub_req.json()
    for dep in sub_staff['result']:
        users |= find_users(dep['url'], token)
    return users


def find_our_services():
    adr = "http://workplace.n.yandex-team.ru/api/workplace.services.CatalogService/listRecords?vertical=rtc"
    req = requests.get(adr)
    staff = req.json()
    return [obj['service'] for obj in staff["objects"]]



def short_data(dt):
    return dateutil.parser.parse(dt).replace(tzinfo=None).strftime("%Y-%m-%d")


def find_service(lis):
    return [ser.lower()[8:] for ser in issue.tags if ser.lower().startswith('service:')]
    ans = ""
    for st in lis:
        if st.lower().startswith('service:'):
            ans = st.lower()[8:]
            break
    return ans.lower() if len(ans) else "None"


def make_queue(dom_list, start_date=None, end_date=None):
    ans = "("
    for dom in dom_list[:-1]:
        ans += "Queue: " + dom + " OR "
    ans += "Queue: " + dom_list[-1] + ")"
    if start_date:
        ans += " AND Created:>=" + start_date
    if end_date:
        ans += " AND Created:<=" + end_date
    return ans


def str2bool(v):
    if isinstance(v, bool):
       return v
    if v.lower() in ('yes', 'true', 't', 'y', '1'):
        return True
    elif v.lower() in ('no', 'false', 'f', 'n', '0'):
        return False
    else:
        raise argparse.ArgumentTypeError('Boolean value expected.')


if __name__ == "__main__":
    job_context = nv.context()
    outputs = job_context.get_outputs()
    parser = argparse.ArgumentParser()
    rtc_list = find_our_services()
    parser.add_argument('--token', help='TRACKER TOKEN', type=str, default=None)
    parser.add_argument('-sd', '--start_date', help='QUEUES STARTDATE, DEF=2019-01-01', type=str, default='2019-01-01')
    parser.add_argument('-ed', '--end_date', help='QUEUES ENDDATE, DEF=today()', type=str, default='today()')
    parser.add_argument('-q', '--queues', help='QUEUES, DEF=SPI', nargs='+', default=['SPI'])
    parser.add_argument('--gna', help='INTERSECT WITH SERVICES, DEF=LONGLIST', nargs='+', default=rtc_list)
    parser.add_argument("--need_gna", type=str2bool, default=True, help="ACTIVATE INTERSECT WITH SERVICES, DEF=true")
    parser.add_argument('-dep', '--department', help='INTERSECT WITH DEPARTMENT FOLLOWERS, DEF=yandex_mnt_sa_runtime_mondev',
                        type=str, default='yandex_mnt_sa_runtime_mondev')
    parser.add_argument("--need_fol", type=str2bool, default=False, help="ACTIVATE INTERSECT WITH DEPARTMENT FOLLOWERS, DEF=false")
    parser.add_argument("--data_in_isa", type=str2bool, default=False, help="ACTIVATE INTERSECT WITH DEPARTMENT FOLLOWERS, DEF=true")
    args = parser.parse_args()
    token_get = args.token
    our_gna = set(args.gna)

    token = choose_credential(token_get, 'TRACKER_TOKEN', '~/.st/token')
    user = "username"
    url2 = 'https://st-api.yandex-team.ru'
    

    for attempt in range(100):
	try:
	    client = Startrek(useragent=user, base_url=url2, token=token)

	    all_dom = args.queues

	    set_users = find_users(args.department, token)

	    queue = make_queue(all_dom, args.start_date, args.end_date)
	    issues = client.issues.find(queue)


	    data_in_ISA = args.data_in_isa
	    ans_list = []


	    for issue in issues:
		set_follower = set([fol.login for fol in issue.followers])
		assignee = issue.assignee.login if issue.assignee else "None"
		service_names = find_service(issue.tags)
		for service_name in service_names:
		    if not (assignee in set_users or len(set_follower & set_users) > 0) and service_name in our_gna:
		        pass
		    """
		    00 -> 1
		    01 -> 1
		    10 -> 0
		    11 -> 1
		    """
		    if (not args.need_gna or service_name in our_gna) and \
		            (not args.need_fol or (assignee in set_users or len(set_follower & set_users) > 0)):
		        ans_list.append({'key': issue.key, 'fielddate': issue.createdAt if data_in_ISA else short_data(issue.createdAt),
		                         'status': issue.status.key, 'service': service_name})

	    with open(outputs.get("data_file.json"), "w") as write_file:
		json.dump(ans_list, write_file)
	    break
	except:
	    sleep(attempt)
	    continue


