import yt.wrapper
import sys


def init():
    print("Программа для генерации примеров запросов для для сборщика метрик из Соломона.")
    print("Введите название YT-кластера, в котором будут храниться таблицы.")
    proxy = sys.stdin.readline().strip()
    print("Введите адрес директории на кластере. В ней будет создана поддиректория /smc, в которой будет находиться \
таблица /input с входными данными, а также выходные таблицы с выходными данными после выполнения запроса.")
    path = sys.stdin.readline().strip()
    print("Введите номер примера. Доступные примеры:")
    print("\t1. Сбор сигналов со всех подов, принадлежащих одному ABC")
    print("\t2. Сбор сигналов со всех подов, принадлежащих одному под-сервису")
    print("\t3. Сбор нескольких сигналов с подов с разными агрегациями")
    print("\t4. Сбор сигналов с подов за несколько временных интервалов")
    print("\t5. Сбор гистограммных сигналов с подов с сохранением самой гистограммы")
    print("\t6. Сбор скалярных сигналов с подов с аггрегацией в гистограмму")
    print("\t7. Сбор скалярных сигналов с подов в сыром виде с сэмплированием")
    print("\t8. Сбор сигналов со всех хостов, принадлежащих одному WallE проекту")
    print("\t9. Сбор сигналов со всех хостов, принадлежащих одному WallE проекту с разделением по тегу")
    num = int(sys.stdin.readline().strip()) - 1
    return proxy, path, num


def write_table(proxy, path, num):
    jsonians = [
        [{"abc": "36"}],
        [{"service": "yt_cms"}],
        [{"abc": "36"}],
        [{"abc": "36"}],
        [{"abc": "36"}],
        [{"abc": "36"}],
        [{"abc": "36"}],
        [{"prj": "yp-iss-man-gpu"}],
        [{"prj": "yp-iss-man-gpu"}]
    ]
    if num < 0 or num >= len(jsonians):
        raise ValueError("Num is too big")
    yt.wrapper.config.set_proxy(proxy)
    try:
        yt.wrapper.mkdir(path + "/smc")
    except:
        pass
    yt.wrapper.write_table(path + "/smc/input", jsonians[num], raw=False)


def write_query(proxy, path, num):
    sigs = [
        "\tavg:portoinst-cpu_usage_cores_tvvv",
        "\tavg:portoinst-cpu_usage_cores_tvvv",
        "\tavg|min|max:portoinst-anon_usage_gb_tmmv||portoinst-io_alloc_hdd_read_bw_bytes_tmmv\n\
\tpercentile(95,97,99):portoinst-cpu_limit_usage_perc_hgram||portoinst-cpu_system_limit_usage_perc_hgram",
        "\tavg:portoinst-cpu_usage_cores_tvvv",
        "\thist:portoinst-cpu_limit_usage_perc_hgram||portoinst-net_tx_speed_hgram",
        "\thist:portoinst-cpu_usage_cores_tvvv",
        "\traw:portoinst-cpu_usage_cores_tvvv",
        "\tavg:cpu-id_hgram",
        "\tavg:push-gpustat-utilization_gpu_tvvv"
    ]

    input_type = [
        "abcs",
        "services",
        "abcs",
        "abcs",
        "abcs",
        "abcs",
        "abcs",
        "walles",
        "walles"
    ]

    with open("../query.txt", "w") as query:
        print("SELECT", file=query)
        print(sigs[num], file=query)
        print("PERIODS", file=query)
        if num == 3:
            print("\t-01:03:00:00 to -01:02:00:00\n\t-01:02:00:00 to -01:01:00:00\n\t-01:01:00:00 to -01:00:00:00",
                file=query)
        else:
            print("\t-01:01:00:00 to -01:00:00:00", file=query)
        print("FROM " + input_type[num] + ":" + path + "/smc/input", file=query)
        print("CACHE " + path + "/smc/cache", file=query)
        print("TO " + path + "/smc/output", file=query)
        print("ERROR " + path + "/smc/error", file=query)
        print("PROXY " + proxy, file=query)
        if num == 6:
            print("RAWSAMPLING 0.1", file=query)
        if num == 8:
            print("TAGS gpu_path", file=query)


if __name__ == "__main__":
    proxy, path, num = init()
    write_table(proxy, path, num)
    write_query(proxy, path, num)