import sys
import os
import psutil
import yt.wrapper

#FIXME: отредактировать при переносе из джанка
from junk.p34k1n.yasm_metrics_collect.requests import get_all_pods_from_abc, get_all_pods_from_service, get_pod_info
from junk.p34k1n.yasm_metrics_collect.requests import get_walle_hosts, get_host_tags
from junk.p34k1n.yasm_metrics_collect.data import get_data


class AbcToPodsMapper(object):
    def __init__(self, yp_token, clusters):
        self.yp_token = yp_token
        self.clusters = clusters

    def __call__(self, row):
        abc = row["abc"]
        print("starting to process abc {0}".format(abc), file=sys.stderr)
        yp_token = self.yp_token
        clusters = self.clusters
        for clst in clusters:
            for pod in get_all_pods_from_abc(abc, clst, yp_token):
                yield {
                    "id": pod[0],
                    "spec": pod[1],
                    "labels": pod[2],
                    "pod_set_id": pod[3],
                    "clst": pod[4],
                    "abc": pod[5]
                }
        print("finished to process abc {0}".format(abc), file=sys.stderr)


class ServiceToPodsMapper(object):
    def __init__(self, yp_token, clusters):
        self.yp_token = yp_token
        self.clusters = clusters

    def __call__(self, row):
        service = row["service"]
        print("starting to process service {0}".format(service), file=sys.stderr)
        yp_token = self.yp_token
        for clst in self.clusters:
            for pod in get_all_pods_from_service(service, clst, yp_token):
                yield {
                    "id": pod[0],
                    "spec": pod[1],
                    "labels": pod[2],
                    "pod_set_id": pod[3],
                    "clst": pod[4],
                    "abc": pod[5]
                }


class PodsToPodsMapper(object):
    def __init__(self, yp_token):
        self.yp_token = yp_token

    def __call__(self, row):
        pod = row["pod"]
        clst = row["cluster"]
        print("starting to process pod {0}".format(pod), file=sys.stderr)
        yp_token = self.yp_token
        raw_pod = get_pod_info(pod, clst, yp_token)
        yield {
            "id": raw_pod[0],
            "spec": raw_pod[1],
            "labels": raw_pod[2],
            "pod_set_id": raw_pod[3],
            "clst": raw_pod[4],
            "abc": raw_pod[5]
        }


class PodsToMetricsMapper(object):
    def __init__(self, ints, signals, solomon_token, debug, hist_sigs, intv_type, parse_args, raw_sampling):
        self.ints = ints
        self.signals = signals
        self.solomon_token = solomon_token
        self.debug = debug
        self.hist_sigs = hist_sigs
        self.intv_type = intv_type
        self.parse_args = parse_args
        self.raw_sampling = raw_sampling

    def __call__(self, row):
        ints = self.ints
        signals = self.signals
        solomon_token = self.solomon_token
        hist_sigs = self.hist_sigs
        intv_type = self.intv_type
        parse_args = self.parse_args
        raw_sampling = self.raw_sampling
        print("processing pod with id {0}".format(row["id"]), file=sys.stderr)
        for intv in ints:
            entry = get_data(row, "pod", intv[0], intv[1], signals, solomon_token, hist_sigs, intv_type, parse_args, raw_sampling)
            # debug - print memory usage in bytes
            # process = psutil.Process(os.getpid())
            # print(process.memory_info().rss, file=sys.stderr)
            if type(entry) is dict:
                if self.debug:
                    if "error" in entry:
                        yield yt.wrapper.create_table_switch(1)
                    else:
                        yield yt.wrapper.create_table_switch(0)
                    yield entry
                else:
                    if "error" not in entry:
                        yield entry
            else:
                yield yt.wrapper.create_table_switch(0)
                for row in entry:
                    yield row


class WalleToHostsMapper(object):
    def __init__(self, tags):
        self.tags = tags

    def __call__(self, row):
        prj = row["prj"]
        print("starting to process prj {0}".format(prj), file=sys.stderr)
        tags = self.tags
        for host in get_walle_hosts(prj):
            for res_tags in get_host_tags(host, tags, prj):
                yield res_tags


class HostsToHostsMapper(object):
    def __init__(self, tags):
        self.tags = tags

    def __call__(self, row):
        host = row["host"]
        print("starting to process host {0}".format(host), file=sys.stderr)
        tags = self.tags
        for tags in get_host_tags(host, tags):
            yield tags


class HostsToMetricsMapper(object):
    def __init__(self, ints, signals, solomon_token, debug, hist_sigs, intv_type, parse_args, raw_sampling):
        self.ints = ints
        self.signals = signals
        self.solomon_token = solomon_token
        self.debug = debug
        self.hist_sigs = hist_sigs
        self.intv_type = intv_type
        self.parse_args = parse_args
        self.raw_sampling = raw_sampling

    def __call__(self, row):
        ints = self.ints
        signals = self.signals
        solomon_token = self.solomon_token
        hist_sigs = self.hist_sigs
        intv_type = self.intv_type
        parse_args = self.parse_args
        raw_sampling = self.raw_sampling
        print("processing host with id {0}".format(row["host"]), file=sys.stderr)
        for intv in ints:
            entry = get_data(row, "host", intv[0], intv[1], signals, solomon_token, hist_sigs, intv_type, parse_args, raw_sampling)
            # debug - print memory usage in bytes
            # process = psutil.Process(os.getpid())
            # print(process.memory_info().rss, file=sys.stderr)
            if type(entry) is dict:
                if self.debug:
                    if "error" in entry:
                        yield yt.wrapper.create_table_switch(1)
                    else:
                        yield yt.wrapper.create_table_switch(0)
                    yield entry
                else:
                    if "error" not in entry:
                        yield entry
            else:
                yield yt.wrapper.create_table_switch(0)
                for row in entry:
                    yield row
