Утилита, позволяющая собирать произвольный набор метрик из Соломона для произвольного множества подов.  

Запрос подается на вход в текстовом файле, имя которого передается в программу через аргумент --file. Дефолтное имя - query.txt.  

Каждый аргумент записывается в запросе либо строкой вида:  
<НАЗВАНИЕ_ПАРАМЕТРА> <значение>  
Либо последовательностью строк вида:  
<НАЗВАНИЕ_ПАРАМЕТРА>  
    <значение1>  
    <значение2>  
    ...  
    <значениеN>  

Программа исопльзует следующие параметры:  

SELECT - список сигналов и аггрегирующих функций в формате:  
    <аггрегирующая_функция_1>|<аггрегирующая_функция_2>|...|<аггрегирующая_функция_N>:<сигнал_1>||<сигнал_2>||...||<сигнал_M>  

Для сигналов, записанных в одной строке, существуют следующие правила:  
1. Нельзя передавать в одной строке и скалярные, и гистограммные сигналы.  
2. В случае скалярных сигналов нельзя передавать в одной строке сигналы, использующие разные summary-функции.
(см. https://wiki.yandex-team.ru/solomon/userguide/viewing-yasm-data/ пункт 6).  
3. В случае гистограммных сигналов нельзя передавать более одной аггрегирующей функции.  
4. При использовании похостового сбора метрик нельзя указывать более 1 сигнала в строке.  

Доступны следующие аггрегирующие функции:  
- avg: Возвращает среднее значение массива значений/гистограммы.
- median: Возвращает медиану массива значений, в случае гистограммы - синоним percentile(50).
- mode: Возвращает моду массива значений, недоступна для гистограммы.
- sum: Возвращает сумму массива значений/гистограммы.
- min: Возвращает минимальное значение в массиве, в случае гистограммы - синоним percentile(0).
- max: Возвращает максимальное значение в массиве, в случае гистограммы - синоним percentile(100) 
- percentile(q1, q2, ...): Возвращает поданные перцентили массива/гистограммы.
Важно - на вход подаются числа от 0 до 100, а не от 0 до 1.
- histogram: В случае гистограммы возвращает таковую в неизменном виде. В случае массива возвращает 
гистограмму в формате:

```
{  
    "zeroes": <число нулей в исходном массиве>,  
    "edges": <границы гистограммных бакетов>,  
    "counts": <количества значений в гистограммных бакетах>  
}  
```

- raw: Недоступен для гистограммы, для массива же записывает данные в специальном виде:  
Вместо одной строки с агрегированным значением записывает для каждого пятисекундного
timestamp'а его самого и значение сигнала в этот момент времени. В силу особненности формата записи
данный вид агрегации не может использоваться в одном запросе с какими-либо другими видами аггрегации,
а также с гистограммными сигналами. Данный можно случайным образом сэмплировать, задав долю
записываемых значений параметром RAWSAMPLING.


PERIODS - список периодов, за которые нужно собрать сигналы, в формате:  
    <время начала> to <время конца>  

Время можно задать в одном из следующих форматов:  
- Абсолютный: YYYY-MM-DD HH:MM:SS
- Относительный: -DD:HH:MM:SS - отматывает на заданное время относииельно текущего момента.

FROM - задает входную таблицу в формате:  
FROM <тип входа>:<путь к таблице в YT>  

Существуют следующие типы входа: 
Per-pod сбор:  
- abcs - в таблице присутствует один столбец с названием "abc", значениями которого являются строки -
ID нужных ABC-сервисов. Программа соберет сигналы со всех подов, принадлежащих данным ABC.
- services - в таблице присутствует один столбец с названием "service", значениями которого являются строки -
названия нужных под-сервисов. Программа соберет сигналы со всех подов, принадлежащих данным сервисам.
- pods - в таблице присутствуют 2 столбца с названиями "pod" и "cluster", значениями которых являются строки -
названия нужных подов и кластеров, на которых находятся данные поды, соответственно. Программа соберет сигналы
со всех поданных подов.
- pods_cached - см. параметр CACHE.
Per-host сбор:  
- walles - в таблице присутствует один столбец с названием "prj", значениями которого являются строки - 
названия WallE-проектов. Программа соберет сигналы со всех хостов, принадлежащих данным проектам.
- hosts - в таблице присутствует один столбец с названием "host", значениями которого являются строки - 
адреса хостов. Программа соберет сигналы со всех указанных хостов.
- hosts_cached - см. параметр CACHE.

CLUSTERS - задает кластеры, с которых нужно собрать поды, через запятую. Используется только при типах входа 
abcs и services.

TAGS - в случае похостового сбора метрик можно указать, по каким тегам нужно разбить сигналы с одного хоста. 
Например, для метрики push-gpustat-utilization_gpu_tvvv можно указать тег gpu_path и получить значение для каждого
из установленных на хосте GPU по отдельности, в противном случае вернется одно агрегированное значение для хоста 
(в данном случае - среднее со всех GPU).

JOBS - задает число джобов, которые будет использовать YT для мапа. Задается двумя числами - первое означает число
джобов, используемых в мапе из входной таблицы в кэш (не используется при типе входа pods_cached), второе - число
джобов, используемых в мапе из кэша в выходную таблицу (в случае pods_cached - из входной в выходную). Можно
задать одним значением - тогда такое число джобов будет использоваться в обоих мапах. По умолчанию в обоих
мапах используется 100 джобов.

Все дальнейшие параметры содержат единственное значение, передающееся в формате <НАЗВАНИЕ_ПАРАМЕТРА> <значение>.  

PROXY - задает кластер, на котором хранятся таблицы с данными. По умолчанию используется hahn.  

CACHE - в случае, если тип входа - abcs, services или pods, программа сохраняет данные о подах из YP в указанной
таблице в следующем формате: 

```
{  
    "abc": < ID ABC-сервиса, которому принадлежит под>,  
    "clst": <название кластера, на котором находится под>,  
    "id": < ID пода (из YP /meta/id)>,  
    "labels": <из YP /labels>,  
    "pod_set_id": <из YP /meta/pod_set_id>,  
    "spec": <из YP /spec> 
}  
```

В случае, если тип входа - walles или hosts, программа записывает данные о хостах в указанной таблице в 
следующем формате:

```
{  
    "host": < ID хоста>,  
    "prj": <название WallE-проекта (в случае типа входа walles)>,  
    "itype": "runtimecloud",  
    <тег>: <значение> для всех тегов, указанных в параметре TAGS
}  
```

По умолчанию записывает в таблицу //tmp/<имя_пользователя>/yasmcache<случайное_число>. Таблицу позже можно подать
на вход программе с типом pods_cache/hosts_cache.  

TO - задает путь к выходной таблице.  

ERROR - задает путь к таблице, в которую будет записана информация о подах, для которых не удалось собрать сигналы.
Если не указан, данные о них не будут записаны.  

TIMEFORMAT - задает формат, в котором будут записаны начало и конец периода замера в таблице. Доступны следующие 
форматы:  
- timestamp  
- str: дата в формате "%Y-%m-%dT%H:%M:%S.%fZ"  
- both: список [timestamp, str]  

PARSEAGGRS - указывает, нужно ли разделять аггрегированные значения в отдельные столбцы. В случае положительного
значения будут записаны в формате:

```
{
    "<название сигнала>:<название аггрегатора>": <значения сигнала>
} 
```

В случае
отрицательного - в формате:  

```
{  
    "<название сигнала>": {  
        "<название аггрегатора>": <значение сигнала>  
    }  
}  
```

RAWSAMPLING - число от 0 до 1; указывает, какую долю значений при raw-агрегации записывать в таблицу. 
По умолчанию 1.

COLLECTALL - особый режим работы программы. Требует только параметры TO и PROXY. При значении abcs выгружает в
указанную таблицу все активные ABC-сервисы. При значении walles выгружает в указанную таблицу все WallE-проекты
с тегом rtc

Примеры запросов можно сгенерировать при помощи программы в example_generator.