import statistics
import numpy as np
import math
import sys


def is_histogram(signals):
    sg = signals.split("||")[0]
    return sg.endswith("hgram") or sg.endswith("hhh")


def list_to_histogram(lst, max_size):
    np_lst = np.array(lst)

    zeroes = len(np_lst[np_lst == 0])
    np_lst = np_lst[np_lst != 0]

    np_lst = np.sort(np_lst)
    np_hst = np.histogram(np_lst, bins="auto")

    size = sys.getsizeof(np_hst)
    if size > max_size:
        true_size = int(len(np_hst[0]) * max_size / size)
        np_hst = np.histogram(np_lst, bins=true_size)

    return {
        "zeroes": zeroes,
        "edges": np_hst[1].tolist(),
        "counts": np_hst[0].tolist()
    }


def get_summary(signal):
    infix = signal[-3:-1]
    wrapmap = {
        "nn": "summary_min",
        "xx": "summary_max",
        "mm": "summary_sum",
        "ee": "summary_sum",
        "um": "summary_sum", #_summ
        "tt": "summary_last",
        "vv": "summary_avg"
    }
    return wrapmap.get(infix, "")


def get_series(signal):
    infix = signal[-3:-1]
    wrapmap = {
        "nn": "series_min",
        "xx": "series_max",
        "mm": "series_sum",
        "ee": "series_sum",
        "um": "series_sum", #_summ
        "tt": "series_avg",
        "vv": "series_avg",
        "hh": "series_sum",
        "ra": "series_sum", #_hgram
    }
    return wrapmap.get(infix, "")


def get_histogram_func(func):
    if func.startswith("percentile"):
        percentiles = func[len("percentile"):].strip("()").split(",")
        if len(percentiles) > 1:
            return "histogram_percentile,as_vector(" + ",".join(percentiles) + ")"
        else:
            return "histogram_percentile," + percentiles[0] + ")"

    funcmap = {
        "sum": "histogram_sum",
        "avg": "histogram_avg",
        "max": "histogram_percentile,100",
        "min": "histogram_percentile,0",
        "median": "histogram_percentile,50",
        "hist": ""
    }
    if func not in funcmap:
        raise Exception("Unknown aggregator: {0}".format(func))
    return funcmap[func]


def filter_nans(lst):
    for i in range(len(lst)):
        if type(lst[i]) not in [float, int] or math.isnan(lst[i]):
            lst[i] = 0.0


def get_list_func(lst, func, max_size):
    filter_nans(lst)

    if func.startswith("percentile"):
        percentiles = [float(num.strip()) for num in func.replace("percentile", "").strip("()").split(",")]
        res = np.percentile(lst, percentiles).tolist()
        return {
            "percentile_" + str(percentiles[i]): res[i] for i in range(len(percentiles))
        }

    funcmap = {
        "hist": lambda x: list_to_histogram(x, max_size),
        "avg": statistics.mean,
        "median": statistics.median,
        "mode": statistics.mode,
        "sum": sum,
        "max": max,
        "min": min
    }
    if func not in funcmap:
        raise Exception("Unknown aggregator: {0}".format(func))

    return {func: funcmap[func](lst)}

