# ssh_permissions_vs_resolving
# leonidkiselev
from infra.rsm.perfmanager.scripts.resolve_cgrps.abc_api_wrapper import AbcApi
from infra.rsm.perfmanager.scripts.resolve_cgrps.utils import get_table_name, split_chunks, extract_top_parents, extract_gencfg_group_itag_position, clean_abc_id, DEFAULT_ABC_SERVICE
import nirvana.job_context as nv
import requests
import threading
import time
from yp.client import YpClient, find_token
import yt.wrapper as yt


def get_deploy_projects():
    projects_mapping = {}
    client = YpClient("xdc", config=dict(token=find_token()))
    projects = client.select_objects("project", selectors=["/meta/id", "/meta/account_id"])

    for record in projects:
        projects_mapping[record[0]] = record[1]

    return projects_mapping


def prepare_gencfg_mapping():
    yt.config.set_proxy("hahn")
    gencfg_table = get_table_name()

    gencfg_abc_map = {}

    for record in yt.read_table(gencfg_table):
        gencfg_abc_map[record["group_name"]] = record["account_id"]

    return gencfg_abc_map


def extract_abc_params(abc_id, abc_api):
    technical_abc = False

    if not abc_id or abc_id == DEFAULT_ABC_SERVICE:
        return
    else:
        try:
            abc_integer = int(clean_abc_id(abc_id))
        except ValueError:
            technical_abc = True
            abc_integer = None

        if technical_abc:
            return "Unknown"

        service_name = abc_api.get_service_name(abc_api.get_service_slug(service_id=abc_integer))
        service_parents = abc_api.get_service_parents_names(service_id=abc_integer)

        highest_parent, previous_parent = extract_top_parents(service_name, service_parents)

        if len([i for i in [highest_parent, previous_parent, service_name] if "(VS)" in i]) > 0:
            return [i for i in [highest_parent, previous_parent, service_name] if "(VS)" in i][0]
        else:
            return highest_parent


def resolve_gencfg_service(servicename, gencfg_mapping, abc_api, token):
    headers = {"Authorization": "OAuth {}".format(token)}

    servicename = servicename[6::]
    url = "https://nanny.yandex-team.ru/v2/services/{0}/current_state/instances/".format(servicename)

    while True:
        try:
            data = requests.get(url, headers=headers).json().get("result", [])
            break
        except:
            continue

    if len(data) > 0:

        itags = data[0].get("itags", [])
        if len(itags) > 0:
            group_index = extract_gencfg_group_itag_position(itags)

            if group_index is None:
                return

            gencfg_group = itags[group_index]

            try:
                mapping = extract_abc_params(gencfg_mapping[gencfg_group], abc_api)
            except:
                return
            return mapping

    else:
        return "Unknown"


def get_vs_or_top_nanny(table_projects, abc, VSs, gencfg_map, token):
    headers = {"Authorization": "OAuth {}".format(token)}

    for system_id in table_projects:
        url = "https://nanny.yandex-team.ru/v2/services/{}/info_attrs/".format(system_id[6::])

        while True:
            try:
                id = requests.get(url, headers=headers).json().get("content", {}).get("abc_group", "Unknown")
                break
            except requests.exceptions.ConnectionError:
                time.sleep(10)

        if id == 0 or id == "Unknown":
            vs_or_top = resolve_gencfg_service(system_id, gencfg_map, abc, token)
        else:
            vs_or_top = abc.get_service_vs_or_top(service_id=id)

        VSs[system_id] = vs_or_top

    return VSs


def parallelized_nanny_resolving(table_projects, abc, VSs, gencfg_map, token):
    splitted = list(split_chunks(table_projects, int(len(table_projects) / 8)))
    threads = []

    for i in range(len(splitted)):
        t = threading.Thread(target=get_vs_or_top_nanny, args=(splitted[i], abc, VSs, gencfg_map, token))
        t.start()
        threads.append(t)

    for thread in threads:
        thread.join()


def get_vs_or_top(VSs_deploy, VSs_nanny, abc):
    VS = (VSs_deploy | VSs_nanny)
    table = []
    for name in VS:
        is_deploy = (name[:6] == "deploy")
        deploy_system = "nanny"
        short = name[6:]
        if is_deploy:
            deploy_system = "deploy"
            short = name[7:]
        table.append({
            "deploy system" : deploy_system,
            "project" : short,
            "VS or Top slug" : VS[name],
            "VS or Top name" : abc.get_service_name(VS[name]),
        })
    return table


def write_table(table_path, table):
    dst_table = yt.TablePath(table_path, append=False)

    yt.write_table(
        dst_table,
        table,
    )


def get_vs_or_top_deploy(projects, table_projects, abc):
    table_projects_names = set([i[1] for i in table_projects])
    VSs = {}

    for project in projects:
        name = "deploy:" + project[0]
        if name not in table_projects_names:
            continue
        id = project[1]
        if id == "tmp":
            VSs[name] = "Unknown"
            continue
        id = int(id[12:])
        vs_or_top = abc.get_service_vs_or_top(service_id=id)
        VSs[name] = vs_or_top

    return VSs


def resolve_vs(abc, token):

    projects_path = "//home/runtimecloud/RTCANALYTICS-219/projects"
    vs_path = "//home/runtimecloud/RTCANALYTICS-219/system_id_vs_mapping"
    nanny_systems = []
    gencfg_abc_map = prepare_gencfg_mapping()
    deploy_systems_full = get_deploy_projects()
    resolved_services = {}
    mapping_data = []

    for record in yt.read_table(vs_path):
        system_id, value_stream = record["system_id"], record["vs"]
        resolved_services[system_id] = value_stream

    for record in yt.read_table(projects_path):
        system_id, project = record["system_id"], record["project"]
        if system_id in resolved_services:
            continue

        if system_id[0:5] == "nanny":
            nanny_systems.append(system_id)
        else:
            try:
                resolved_services[system_id] = abc.get_service_name(abc.get_service_vs_or_top(service_id=int(deploy_systems_full.get(project[7::]).replace("abc:service:", ""))))
            except:
                resolved_services[system_id] = "Unknown"

    if len(nanny_systems) > 0:
        parallelized_nanny_resolving(nanny_systems, abc, resolved_services, gencfg_abc_map, token)
    
    for system_id, value_stream in resolved_services.items():
        vs = value_stream
        if system_id[0:5] == "nanny":
            try:
                value_stream = abc.get_service_name(vs)
            except:
                value_stream = vs
        mapping_data.append({"vs": value_stream, "system_id": system_id})

    yt.write_table(vs_path, mapping_data)


def main():
    parameters = nv.context().get_parameters()
    nanny_token = parameters.get("NANNY_TOKEN")
    ABC_TOKEN = parameters.get("ABC_TOKEN")

    abc = AbcApi(token=ABC_TOKEN)
    abc.load_abc_service_tree()
    proxy = "hahn"

    resolve_vs(abc, nanny_token)


if __name__ == "__main__":
    main()

