# support_estimate_statistics
# leonidkiselev
from datetime import datetime, date, time, timedelta
import nirvana.job_context as nv
import os
import requests
from startrek_client import Startrek
from yql.api.v1.client import YqlClient
import yt.wrapper as yt


def main():
    parameters = nv.context().get_parameters()
    token = parameters.get("startrektoken")
    FROM = parameters.get("from")
    TO = parameters.get("to")

    tasks = [issue.key for issue in get_issues(token, FROM, TO)]
    print("DONE", len(tasks), "tasks")
    if (not FROM) and (not TO):
        tickets = set()
    else:
        tickets = get_tickets()
    creators = []
    resolvers = []
    table, tag_table = result(token, tasks, tickets, creators, resolvers)
    schema = [
        {"name": "Issue", "type": "string"},
        {"name": "Creator", "type": "string"},
        {"name": "Created at", "type": "date"},
        {"name": "Resolver", "type": "string"},
        {"name": "Resolved at", "type": "date"},
        {"name": "Time, hours", "type": "float"},
    ]

    append = True  # если параметры не None, то добавляем наши строки в таблицу
    if (not FROM) and (not TO):  # иначе создаем новую таблицу, которую заполняем нашими строками
        append = False
    create_table(
        "//home/runtimecloud/RTCANALYTICS-209/RTCSUPPORT_Issue_Timeline",
        "hahn",
        append,
        schema,
    )
    write_table(
        "//home/runtimecloud/RTCANALYTICS-209/RTCSUPPORT_Issue_Timeline",
        table,
        append,
    )

    create_table(
        "//home/runtimecloud/RTCANALYTICS-209/RTCSUPPORT_Issue_Tags",
        "hahn",
        append,
        [{"name": "Issue", "type": "string"}, {"name": "Tag", "type": "string"}]
    )
    write_table(
        "//home/runtimecloud/RTCANALYTICS-209/RTCSUPPORT_Issue_Tags",
        tag_table,
        append,
    )


def get_interval(FROM, TO):
    return {
        "from": FROM,
        "to": TO
    }


def get_non_working_days():
    holidays = {}
    non_working_days = set()
    day = date(2022, 1, 1)
    while day != date(2023, 1, 1):
        if day.weekday() >= 6 and day != date(2022, 3, 5):
            non_working_days.add(day)
        if date(2022, 1, 1) <= day <= date(2022, 1, 8) or day == date(2022, 2, 23) or date(2022, 3, 7) <= day <= date(2022, 3, 8) or date(2022, 5, 2) <= day <= date(2022, 5, 3) or date(2022, 5, 9) <= day <= date(2022, 5, 10) or day == date(2022, 6, 13) or day == date(2022, 11, 4):
            non_working_days.add(day)
        day += timedelta(days=1)
    holidays[2022] = non_working_days
    return holidays


def get_issues(token, FROM, TO):
    today = str(datetime.today().date())
    period = str(datetime.today().date() - timedelta(days=100))  # 100 дней назад
    day = str(datetime.today().date() - timedelta(days=2))  # 2 дня назад

    if (not FROM) and (not TO):  # загружаем за последние 100 дней
        interval = get_interval(period, today)
    elif (FROM == "Auto") and (TO == "Auto"):  # загружаем за последние 2 дня, с момента последнего обновления кода
        interval = get_interval(day, today)
    else:
        interval = get_interval(FROM, TO)

    issues = Startrek(useragent="leonidkiselev", token=token).issues.find(
        filter={"queue": "RTCSUPPORT", "resolved": interval}
    )
    return issues


def transform_time(date_and_time):
    """ преобразуем строку в datetime """
    return datetime.strptime(date_and_time[:19], "%Y-%m-%dT%H:%M:%S")


def find_status(data):
    """ ищем моменты смены статуса """
    changes = []
    review_time = "2100-01-01T00:00:00"
    for issue in data:
        if "fields" in issue:
            change_name, change_time = None, None
            for field in issue["fields"]:
                if field.get("field"):
                    if field["field"].get("display") == "Статус" and "from" in field and "to" in field:
                        try:
                            _from = field["from"].get("display")
                        except AttributeError:
                            _from = None
                        try:
                            _to = field["to"].get("display")
                        except AttributeError:
                            _to = None
                        change_name = (_from, _to)
                    if field["field"].get("display") == "Статус изменен" and "from" in field and "to" in field:
                        _from, _to = field["from"], field["to"]
                        change_time = (_from, _to)
            if change_name and change_time:
                changes.append({
                    "name": change_name,
                    "time": change_time
                })
                if change_name[0] == "Требует ревью":
                    review_time = change_time[0]
    return changes, review_time


def get_tickets():
    """ достаем тикеты, уже находящиеся в таблице """
    client = YqlClient(db='hahn')
    tickets = set()

    query = '''
    SELECT DISTINCT Issue FROM hahn.`home/runtimecloud/RTCANALYTICS-209/RTCSUPPORT_Issue_Timeline`
    '''

    request = client.query(
        query,
        syntax_version=1
    )

    request.run()

    for table in request.get_results():
        table.fetch_full_data()

        for row in table.rows:
            tickets.add(row[0])

    return tickets


def result(token, tasks, tickets, creators, resolvers):
    counter = 0
    table = []
    tag_table = []
    Unix = date(1970, 1, 1)

    for task in tasks:
        if task in tickets:  # пропускаем уже имеющиеся в таблице тикеты
            continue

        counter += 1
        if counter % 100 == 0:
            print("task", counter / 1000, "k")

        data_url = "https://st-api.yandex-team.ru/v2/issues/{}".format(task)
        changelog_url = "https://st-api.yandex-team.ru/v2/issues/{}/changelog?perPage=10000".format(task)
        headers = {"Authorization": "OAuth {}".format(token)}
        data = requests.get(data_url, headers=headers).json()
        changelog = requests.get(changelog_url, headers=headers).json()

        tags = []
        if "tags" in data:
            tags = data["tags"]

        # добавляем теги в таблицу
        for tag in tags:
            row = {
                "Issue": task,
                "Tag": tag,
            }
            tag_table.append(row)
        tag_table.append({"Issue": task, "Tag": "--ALL TAGS--"})

        if "createdAt" not in data or "resolvedAt" not in data:
            print(task)
            continue

        creator = data["createdBy"]["display"]
        creators.append(creator)

        resolver = "Unknown"
        if "assignee" in data:
            resolver = data["assignee"]["display"]
        resolvers.append(resolver)

        changes, review_time = find_status(changelog)
        start, finish = transform_time(data["createdAt"]), transform_time(data["resolvedAt"]) if transform_time(data["resolvedAt"]) < transform_time(review_time) else transform_time(review_time) # дата создания и закрытия тикета
        start_date, finish_date = start.date(), finish.date()

        """ для каждого статуса считаем суммарное время, которое тикет провел в этом статусе """
        times_per_status = {}
        holidays = get_non_working_days()[2022]
        for change in changes:
            status = change["name"][0]
            begin, end = transform_time(change["time"][0]), transform_time(change["time"][1])
            # проверяем на нерабочие дни
            non_working_seconds = 0
            day = begin + timedelta(days=1)
            while day <= end - timedelta(days=1):
                if day.date() in holidays:
                    non_working_seconds += 86400
                else:
                    non_working_seconds += 57600
                day += timedelta(days=1)

            status_time = (end - begin).total_seconds() - non_working_seconds
            if status not in times_per_status:
                times_per_status[status] = 0
            times_per_status[status] += status_time

        """ считаем чистое время исполнения тикета """
        dirty_statuses = {"requestApprove", "needReproduce", "needInfo", "onTheSideOfUser"}
        clean_time = 0
        for status in times_per_status:
            if status in dirty_statuses:
                continue
            clean_time += times_per_status[status]
        clean_time /= 3600
        clean_time = round(clean_time, 1)

        # добавляем строчку в таблицу
        row = {
            "Issue": task,
            "Creator": creator,
            "Created at": (start_date - Unix).days,
            "Resolver": resolver,
            "Resolved at": (finish_date - Unix).days,
            "Time, hours": clean_time,
        }
        table.append(row)

    print("DONE")
    return table, tag_table


def create_table(table_path, proxy, append, schema):
    yt.config.set_proxy(proxy)
    dst_table = yt.TablePath(table_path, append=append)

    yt.create(
        "table",
        dst_table,
        ignore_existing=True,
        recursive=True,
        attributes={
            "schema": schema,
            "dynamic": False
        }
    )


def write_table(table_path, table, append):
    dst_table = yt.TablePath(table_path, append=append)

    yt.write_table(
        dst_table,
        table,
    )


if __name__ == "__main__":
    main()

