import requests
import json
import argparse
import os

import nirvana.job_context as nv

import infra.analytics.io_limits_pipeline.utils as utils


def swapname(old, diff):
    if old in diff:
        return diff[old]
    return old


def change_names(rows, diff):
    for i in range(len(rows)):
        rows[i]["product"] = swapname(rows[i]["product"], diff)
    return rows


def get_abc_slug(abc_id):
    _headers = {'Authorization': 'OAuth {}'.format(os.environ.get("ABC_TOKEN"))}
    url = "https://abc-back.yandex-team.ru/api/v4/services/{0}/?fields=name".format(abc_id)

    result = requests.get(url, headers=_headers).json()

    if result["name"].get("ru"):
        return result["name"]["ru"]
    else:
        return result["name"]["en"]


def main(names_file, rows_file):
    try:
        abc_src = json.load(open(names_file, "r"))
    except:
        abc_src = []
        pass
    diff = {}
    abc_return = []
    for entry in abc_src:
        new_name = get_abc_slug(entry["abc_id"])
        try:
            if new_name != entry["name"]:
                diff[entry["name"]] = new_name
        except:
            pass
        abc_return.append({"abc_id": entry["abc_id"], "name": new_name})
    new_rows = change_names(json.load(open(rows_file, "r")), diff)
    return abc_return, new_rows
    
                
if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("--local_run", type=utils.str2bool, default=False)
    args = parser.parse_args()

    if args.local_run is True:
        old_abc_file = "in.json"
        old_rows_file = "rows.json"
        new_abc_file = "out.json"
        new_rows_file = "new_rows.json"
        
    else:
        job_context = nv.context()
        inputs = job_context.get_inputs()
        outputs = job_context.get_outputs()

        old_abc_file = inputs.get_list("input")[0]
        old_rows_file = inputs.get_list("input")[1]
        new_abc_file = outputs.get("output1")
        new_rows_file = outputs.get("output2")

    abc_names, new_rows = main(old_abc_file, old_rows_file)
    json.dump(abc_names, open(new_abc_file, "w"), indent=4, sort_keys=True)
    json.dump(new_rows, open(new_rows_file, "w"), indent=4, sort_keys=True)

