import datetime
import random


from infra.rtc.analytics.yasm_metrics_collect.requests import construct_request
from infra.rtc.analytics.yasm_metrics_collect.vector import parse_vector
from infra.rtc.analytics.yasm_metrics_collect.utils import is_histogram, get_summary, get_histogram_func, get_series


def extract_nanny(pod):
    try:
        return pod["labels"]["nanny_service_id"]
    except:
        try:
            return pod["labels"]["deploy"]["stage_id"]
        except:
            return pod["pod_set_id"].split(".")[0]


def extract_tags(spec):
    got_tags = False
    tags = {}

    try:
        for entry in spec["iss"]["instances"][0]["properties"]:
            if entry["key"] == "tags":
                for tag in entry["value"].split(" "):
                    parsed_tag = tag.split("_", 2)
                    if parsed_tag[0] == "a":
                        tags[parsed_tag[1]] = parsed_tag[2]
                got_tags = True
    except:
        pass

    try:
        entry = spec["host_infra"]["monitoring"]["labels"]
        for tg, val in entry.items():
            if tg not in tags or tags[tg] == "":
                tags[tg] = val
        got_tags = True
    except:
        pass

    tags["success"] = got_tags
    return tags


def format_signals(sg, period, series=False):
    proc_sg = {}
    proc_sg["signals"] = sg["signals"]
    if is_histogram(sg["signals"]):
        proc_sg["gridMillis"] = 1000 * period
        proc_sg["summary"] = get_histogram_func(sg["aggregation"][0])
        proc_sg["disableDownsampling"] = False
    else:
        proc_sg["gridMillis"] = 5000
        proc_sg["summary"] = get_summary(sg["signals"].split("||")[0])
        proc_sg["disableDownsampling"] = True
    if series:
        proc_sg["series"] = get_series(sg["signals"].split("||")[0])
    proc_sg["aggregation"] = sg["aggregation"]
    return proc_sg

def data_format(tmstp, strf, tp):
    retvals = {
        "timestamp": tmstp,
        "string": strf,
        "both": [tmstp, strf]
    }
    return retvals[tp]


def get_data(row, ph, tmstmp_st, tmstmp_end, signals, solomon_token, hist_sigs, intv_type, parse_aggrs, raw_sampling):
    fmt = "%Y-%m-%dT%H:%M:%S.%fZ"
    collectibles = {}

    collectibles["period"] = [datetime.datetime.fromtimestamp(tmstmp_st).strftime(fmt),
                        datetime.datetime.fromtimestamp(tmstmp_end).strftime(fmt)]
    collectibles["token"] = solomon_token

    result_template = {
        "time_begin": data_format(tmstmp_st, collectibles["period"][0], intv_type),
        "time_end": data_format(tmstmp_end, collectibles["period"][1], intv_type)
    }
    if ph == "pod":
        collectibles["nanny"] = extract_nanny(row)
        collectibles["deploy_stage"] = row["labels"].get("deploy", {}).get("deploy_unit_id", "")

        result_template.update({
            "host": row["spec"]["node_id"],
            "pod": row["id"],
            "nannyservice": collectibles["nanny"],
        })

        collectibles.update(extract_tags(row["spec"]))
        if not collectibles["success"]:
            result_template.update({
                "error": "No tags recieved",
                "details": row["spec"],
            })
            return result_template

        possible_requests = [
            [row["id"] + "." + row["clst"] + ".yp-c.yandex.net", []],
            [row["spec"]["node_id"], ["prj", "deploy_unit"]],
            [row["spec"]["node_id"], ["deploy_unit"]],
            [row["spec"]["node_id"], ["prj"]],
            [row["spec"]["node_id"], []],
        ]

    elif ph == "host":
        collectibles["geo"] = "/SELF"
        collectibles["series_collapse"] = True
        collectibles.update(row)
        result_template.update(row)
        del result_template["itype"]

        tags = list(set(row.keys()) - set(["itype", "host", "prj"]))
        possible_requests = [
            [row["host"], tags + ["geo"]],
            [row["host"], tags],
        ]

    total = {}

    for sg in signals:
        collectibles.update(format_signals(sg, tmstmp_end - tmstmp_st, ph == "host"))
        tries_count = 0

        for rq in possible_requests:
            msg, vect = construct_request(rq[0], collectibles, rq[1])
            if msg != "Recieved no data":
                break
            tries_count += 1

        if msg != "OK":
            result_template.update({
                "error": msg,
                "details": vect,
            })
            return result_template

        itera = parse_vector(vect, collectibles["aggregation"], hist_sigs)

        if "error" in itera:
            total = itera
            break

        if type(itera) is list:
            if total == {}:
                total = itera
            else:
                for i in range(len(total)):
                    total[i].update(itera[i])
            break

        for signal in itera:
            if signal not in total:
                total[signal] = itera[signal]
            else:
                total[signal].update(itera[signal])

    if "error" in total:
        total.update(result_template)
        return total

    if type(total) is list:
        #pprint(total, sys.stderr)
        del result_template["time_begin"]
        del result_template["time_end"]
        thinnedout_total = []
        random.seed(hash(row.get("id", None) or row["node"]))
        for row in total:
            if random.random() <= raw_sampling:
                row.update(result_template)
                thinnedout_total.append(row)
        return thinnedout_total

    if parse_aggrs:
        parsed_total = {}
        for signal, results in total.items():
            if type(results) is dict:
                for aggr, val in results.items():
                    parsed_total[signal + ":" + aggr] = val
            else:
                parsed_total[signal] = results
        total = parsed_total

    total.update(result_template)
    return total
