import yt.wrapper
import sys


def init():
    print("Программа для генерации примеров запросов для для сборщика метрик из Соломона.")
    print("Введите название YT-кластера, в котором будут храниться таблицы.")
    proxy = sys.stdin.readline().strip()
    print("Введите адрес директории на кластере. В ней будет создана поддиректория /smc, в которой будет находиться \
таблица /input с входными данными, а также выходные таблицы с выходными данными после выполнения запроса.")
    path = sys.stdin.readline().strip()
    print("Введите номер примера. Доступные примеры:")
    print("\t1. Сбор сигналов со всех подов, принадлежащих одному ABC")
    print("\t2. Сбор сигналов со всех подов, принадлежащих одному под-сервису")
    print("\t3. Сбор нескольких сигналов с подов с разными агрегациями")
    print("\t4. Сбор сигналов с подов за несколько временных интервалов")
    print("\t5. Сбор гистограммных сигналов с подов с сохранением самой гистограммы")
    print("\t6. Сбор скалярных сигналов с подов с аггрегацией в гистограмму")
    print("\t7. Сбор скалярных сигналов с подов в сыром виде с сэмплированием")
    print("\t8. Сбор сигналов со всех хостов, принадлежащих одному WallE проекту")
    print("\t9. Сбор сигналов со всех хостов, принадлежащих одному WallE проекту с разделением по тегу")
    print("\t10. Сбор сигналов со всех хостов, принадлежащих одному WallE проекту, с перезаписью списка проектов")
    num = int(sys.stdin.readline().strip()) - 1
    return proxy, path, num


def write_table(proxy, path, num):
    jsonians = [
        [{"abc": "36"}],
        [{"service": "yt_cms"}],
        [{"abc": "36"}],
        [{"abc": "36"}],
        [{"abc": "36"}],
        [{"abc": "36"}],
        [{"abc": "36"}],
        [{"prj": "yp-iss-man-gpu"}],
        [{"prj": "yp-iss-man-gpu"}],
        []
    ]
    if num < 0 or num >= len(jsonians):
        raise ValueError("Num is too big")
    yt.wrapper.config.set_proxy(proxy)
    try:
        yt.wrapper.mkdir(path + "/smc")
    except:
        pass
    if len(jsonians[num]) > 0:
        yt.wrapper.write_table(path + "/smc/input", jsonians[num], raw=False)


def write_query(proxy, path, num):
    sigs = [
        " avg:portoinst-cpu_usage_cores_tvvv",
        " avg:portoinst-cpu_usage_cores_tvvv",
        " avg|min|max:portoinst-anon_usage_gb_tmmv||portoinst-io_alloc_hdd_read_bw_bytes_tmmv\n\
\tpercentile(95,97,99):portoinst-cpu_limit_usage_perc_hgram||portoinst-cpu_system_limit_usage_perc_hgram",
        " avg:portoinst-cpu_usage_cores_tvvv",
        " hist:portoinst-cpu_limit_usage_perc_hgram||portoinst-net_tx_speed_hgram",
        " hist:portoinst-cpu_usage_cores_tvvv",
        " raw:portoinst-cpu_usage_cores_tvvv",
        " avg:cpu-id_hgram",
        " avg:push-gpustat-utilization_gpu_tvvv",
        " avg:cpu-id_hgram"
    ]

    input_type = [
        "abcs",
        "services",
        "abcs",
        "abcs",
        "abcs",
        "abcs",
        "abcs",
        "walles",
        "walles",
        "walles"
    ]

    # rawsampling, tags, overwrite = None, None, None
    optional_args = {"rawsampling": None, "tags": None, "overwrite": None}


    if num == 3:
        periods = "PERIODS -01:03:00:00 to -01:02:00:00\nPERIODS -01:02:00:00 to -01:01:00:00\nPERIODS -01:01:00:00 to -01:00:00:00"
    else:
        periods = "PERIODS -01:01:00:00 to -01:00:00:00"

    if num == 6:
        optional_args["rawsampling"] = "RAWSAMPLING 0.1"

    if num == 8:
        optional_args["tags"] = "TAGS gpu_path"

    if num == 9:
        optional_args["overwrite"] = "OVERWRITE yp-iss-man-gpu,yp-iss-iva"

    query_str = "\n".join([
        "SELECT{0}".format(sigs[num]), periods, "FROM " + input_type[num] + ":" + path + "/smc/input",
                                                "CACHE " + path + "/smc/cache", "TO " + path + "/smc/output",
                                                "ERROR " + path + "/smc/error", "PROXY " + proxy,
    ])

    for arg in optional_args.values():
        if arg:
            query_str += "\n" + arg

    with open("../query.txt", "w") as query:
        query.write(query_str)


if __name__ == "__main__":
    proxy, path, num = init()
    write_table(proxy, path, num)
    write_query(proxy, path, num)
