import json


from infra.rtc.analytics.yasm_metrics_collect.utils import get_list_func


def construct_raw_row(result, timestamps, i):
    ret = {
        signal: val[i] for signal, val in result.items()
    }
    ret["time"] = timestamps[i]
    return ret


def parse_vector(vector, aggregators, hist_sigs):
    result = {}
    weird = False

    if len(vector) > 0 and vector[0].get("timeseries"):
        for instance in vector:
            if len(instance["timeseries"]["values"]) == 0:
                return {
                    "error": "Vector values list is empty",
                    "details": vector,
                }
            signal = instance["timeseries"]["labels"]["signal"]
            if signal not in result:
                if instance["timeseries"]["alias"] != "":
                    result[signal] = {
                        instance["timeseries"]["alias"].replace("p", "percentile_"): instance["timeseries"]["values"][0]
                    }
                elif "percentile" in instance["timeseries"]["labels"]:
                    result[signal] = {
                        "percentile" + instance["timeseries"]["labels"]["percentile"]: instance["timeseries"]["values"][0]
                    }
                else:
                    if len(instance["timeseries"]["values"]) == 1:
                        if type(instance["timeseries"]["values"][0]) is dict:
                            result[signal] = {
                                "histogram": instance["timeseries"]["values"][0]
                            }
                        else:
                            result[signal] = instance["timeseries"]["values"][0]
                    else:
                        result[signal] = instance["timeseries"]["values"]
            else:
                if instance["timeseries"]["alias"] != "":
                    result[signal].update({
                        instance["timeseries"]["alias"].replace("p", "percentile_"): instance["timeseries"]["values"][0]
                    })
                elif "percentile" in instance["timeseries"]["labels"]:
                    result[signal].update({
                        "percentile" + instance["timeseries"]["labels"]["percentile"]: instance["timeseries"]["values"][0]
                    })
    else:
        return {
            "error": "Vector has a weird format",
            "details": json.dumps(vector, indent=4)[:2000] + json.dumps(vector[0]["timeseries"]["values"], indent=4)[:2000],
        }

    aggregated_result = {sig: {} for sig in result}

    try:
        max_size = 15 * 1024 * 1024 / hist_sigs
    except:
        max_size = 15 * 1024 * 1024

    for aggreg in aggregators:
        if aggreg == "raw":
            timestamps = vector[0]["timeseries"]["timestamps"]
            return [
                construct_raw_row(result, timestamps, i) for i in range(len(timestamps))
            ]

        for signal in result:
            if type(result[signal]) in [float, int]:
                aggregated_result[signal][aggreg] = result[signal]
            if type(result[signal]) is list:
                aggregated_result[signal].update(get_list_func(result[signal], aggreg, max_size))
            if type(result[signal]) is dict:
                aggregated_result[signal].update(result[signal])

    return aggregated_result
