{# set distro-specific versions #}
{%- if grains.lsb_distrib_codename == 'precise' %}
{%- set rsync_version = '3.0.9-1ubuntu1.1+yandex14' %}
{%- set tzdata_version = '2016j-2ubuntu0.12.04.yandex1' %}

{%- elif grains.lsb_distrib_codename == 'trusty' %}
{%- set rsync_version = '3.1.0-2ubuntu0.2+yandex14' %}
{%- set tzdata_version = '2018i-0ubuntu0.14.04' %}

{%- elif grains.lsb_distrib_codename == 'xenial' %}
{%- set rsync_version = '3.1.1-3ubuntu1.2' %}
{%- set tzdata_version = '2018g-0ubuntu0.16.04' %}

{%- elif grains.lsb_distrib_codename == 'bionic' %}
{%- set rsync_version = '3.1.2-2.1ubuntu1' %}
{%- set tzdata_version = '2019b-0ubuntu0.18.04' %}

{%- endif %}

app_packages:
  pkg.installed:
    - pkgs:
{% if grains['os'] == 'Ubuntu' %}
  {% if grains['osrelease'] == '16.04' %}
      - libcurl3: "7.47.0-1ubuntu2.15"
      - atop: "1.27-3yandex3"
      - bc: "1.06.95-9build1"
      - binutils: "2.26.1-1ubuntu1~16.04.8"
      - bsd-mailx: "8.1.2-0.20160123cvs-2"
      - bsdmainutils: "9.0.6ubuntu3"
      - bzip2: "1.0.6-8ubuntu0.2"
      - curl: "7.47.0-1ubuntu2.15"
      - libcurl3-gnutls: "7.47.0-1ubuntu2.15"
      - cron: "3.0pl1-128ubuntu2"
      - dnsutils: "1:9.10.3.dfsg.P4-8ubuntu1.16"
      - libbind9-140: "1:9.10.3.dfsg.P4-8ubuntu1.16"
      - libdns162: "1:9.10.3.dfsg.P4-8ubuntu1.16"
      - libisc160: "1:9.10.3.dfsg.P4-8ubuntu1.16"
      - libisccfg140: "1:9.10.3.dfsg.P4-8ubuntu1.16"
      - liblwres141: "1:9.10.3.dfsg.P4-8ubuntu1.16"
      - bind9-host: "1:9.10.3.dfsg.P4-8ubuntu1.16"
      - ethtool: "1:4.5-1"
      - file: "1:5.25-2ubuntu1.4"
      - libmagic1: "1:5.25-2ubuntu1.4"
      - git: "1:2.7.4-0ubuntu1.9"
      - htop: "2.0.1-1ubuntu1"
      - iptables: "1.6.0-2ubuntu3"
      - iputils-ping: "3:20121221-5ubuntu2"
      - language-pack-en: "1:16.04+20161009"
      - less: "481-2.1ubuntu0.2"
      - lockfile-progs: "0.1.17"
      - lsb-release: "9.20160110ubuntu0.2"
      - lsof: "4.89+dfsg-0.1"
      - ltrace: "0.7.3-5.1ubuntu4"
      - logrotate: "3.8.7-2ubuntu2.16.04.2"
      - m4: "1.4.17-5"
      - mc: "3:4.8.15-2"
      - netbase: "5.3"
      - netcat-openbsd: "1.105-7ubuntu1"
      - net-tools: "1.60-26ubuntu1"
      - ntpdate: "1:4.2.8p4+dfsg-3ubuntu5.10"
      - openssh-client: "1:7.2p2-4ubuntu2.10"
      - psmisc: "22.21-2.1ubuntu0.1"
      - python: "2.7.12-1~16.04"
      - rsyslog: "8.16.0-1ubuntu3.1"
      - strace: "4.11-1ubuntu3"
      - sudo: "1.8.16-0ubuntu1.9"
      - subversion: "1.9.5-1ubuntu1~yandex22"
      - libsvn1: "1.9.5-1ubuntu1~yandex22"
      - p7zip-full: "9.20.1~dfsg.1-4.2ubuntu0.1"
      - traceroute: "1:2.0.21-1"
      - tcpdump: "4.9.3-0ubuntu0.16.04.1"
      - tshark: "2.6.10-1~ubuntu16.04.0"
      - vim: "2:7.4.1689-3ubuntu1.4"
      - wget: "1.17.1-1ubuntu1.5"
      - xz-utils: "5.1.1alpha+20120614-2ubuntu2"
      - gdb: "7.11.1-0ubuntu1~16.5"
      - libcap2-bin: "1:2.24-12"
      - numactl: "2.0.11-1ubuntu1.1"
      - vmtouch: "1.3.0yandex1"
  {% elif grains['osrelease'] == '18.04' %}
      - libcurl4: "7.58.0-2ubuntu3.9"
      - atop: "2.3.0-1"
      - bc: "1.07.1-2"
      - binutils: "2.30-21ubuntu1~18.04.4"
      - bsd-mailx: "8.1.2-0.20160123cvs-4"
      - bsdmainutils: "11.1.2ubuntu1"
      - bzip2: "1.0.6-8.1ubuntu0.2"
      - curl: "7.58.0-2ubuntu3.9"
      - cron: "3.0pl1-128.1ubuntu1"
      - dnsutils: "1:9.11.3+dfsg-1ubuntu1.12"
      - libbind9-160: "1:9.11.3+dfsg-1ubuntu1.12"
      - libdns1100: "1:9.11.3+dfsg-1ubuntu1.12"
      - libisc169: "1:9.11.3+dfsg-1ubuntu1.12"
      - libisccfg160: "1:9.11.3+dfsg-1ubuntu1.12"
      - liblwres160: "1:9.11.3+dfsg-1ubuntu1.12"
      - bind9-host: "1:9.11.3+dfsg-1ubuntu1.12"
      - libirs160: "1:9.11.3+dfsg-1ubuntu1.12"
      - libisccc160: "1:9.11.3+dfsg-1ubuntu1.12"
      - ethtool: "1:4.15-0ubuntu1"
      - file: "1:5.32-2ubuntu0.4"
      - libmagic1: "1:5.32-2ubuntu0.4"
      - git: "1:2.17.1-1ubuntu0.7"
      - htop: "2.1.0-3"
      - iptables: "1.6.1-2ubuntu2"
      - iputils-ping: "3:20161105-1ubuntu3"
      - language-pack-en: "1:18.04+20190718"
      - less: "487-0.1"
      - lockfile-progs: "0.1.17build1"
      - lsb-release: "9.20170808ubuntu1"
      - lsof: "4.89+dfsg-0.1"
      - ltrace: "0.7.3-6ubuntu1"
      - logrotate: "3.11.0-0.1ubuntu1"
      - m4: "1.4.18-1"
      - mc: "3:4.8.19-1"
      - netbase: "5.4"
      - netcat-openbsd: "1.187-1ubuntu0.1"
      - net-tools: "1.60+git20161116.90da8a0-1ubuntu1"
      - ntpdate: "1:4.2.8p10+dfsg-5ubuntu7.2"
      - openssh-client: "1:7.6p1-4ubuntu0.3"
      - psmisc: "23.1-1ubuntu0.1"
      - python: "2.7.15~rc1-1"
      - rsyslog: "8.32.0-1ubuntu4"
      - strace: "4.21-1ubuntu1"
      - sudo: "1.8.21p2-3ubuntu1.2"
      - subversion: "1.9.7-4ubuntu1"
      - libsvn1: "1.9.7-4ubuntu1"
      - p7zip-full: "16.02+dfsg-6"
      - traceroute: "1:2.1.0-2"
      - tcpdump: "4.9.3-0ubuntu0.18.04.1"
      - tshark: "2.6.10-1~ubuntu18.04.0"
      - vim: "2:8.0.1453-1ubuntu1.3"
      - wget: "1.19.4-1ubuntu2.2"
      - xz-utils: "5.2.2-1.3"
      - gdb: "8.1-0ubuntu3.2"
      - libcap2-bin: "1:2.25-1.2"
      - numactl: "2.0.11-2.1ubuntu0.1"
      - vmtouch: "1.3.0-1"
  {% else %}
      - libcurl3
      - atop
      - bc
      - binutils
      - bsd-mailx
      - bsdmainutils
      - bzip2
      - curl
      - cron
      - dnsutils
      - ethtool
      - file
      - libmagic1
      - git
      - htop
      - IPtables
      - iputils-ping
      - language-pack-en
      - less
      - lockfile-progs
      - lsb-release
      - lsof
      - ltrace
      - logrotate
      - m4
      - mc
      - netbase
      - netcat-openbsd
      - net-tools
      - ntpdate
      - openssh-client
      - psmisc
      - python
      - rsyslog
      - strace
      - sudo
      - subversion
      - libsvn1
      - p7zip-full
      - traceroute
      - tcpdump
      - tshark
      - vim
      - wget
      - xz-utils
      - gdb
      - libcap2-bin
      - numactl
      - vmtouch
  {% endif %}
{% endif %}
      - rsync: {{ rsync_version }}
      - tzdata: {{ tzdata_version }}
      - yandex-porto: "4.18.26"
      - python-portopy: "4.18.26"
      - yandex-search-group-porto: "1.0-10"
