{%- set bsconfig_dirs = [
            '/db/BASE',
            '/db/bsconfig',
            '/db/bsconfig/webcache',
            '/db/www',
            '/db/bin',
]
%}

/place/db:
  file.directory:
    - name: /place/db
    - makedirs: True
    - user: root
    - group: root
    - dir_mode: 775
/db:
  file.symlink:
    - name: /db
    - target: /place/db
    - user: root
    - group: root
    - mode: 755

{%- for dir in bsconfig_dirs %}
{{ dir }}:
  file.directory:
    - name: {{ dir }}
    - makedirs: True
    - user: loadbase
    - group: loadbase
    - dir_mode: 775
{%- endfor %}

/place/coredumps:
  file.directory:
    - user: loadbase
    - group: loadbase
    - mode: 755
    - makedirs: True

# https://st.yandex-team.ru/PORTO-671
/Berkanavt:
  file.symlink:
    - name: /Berkanavt
    - target: /place/berkanavt
    - user: root
    - group: root
    - mode: 755
/Berkanavt/supervisor:
  file.directory:
    - user: root
    - group: root
    - mode: 755

/usr/local/www:
  file.symlink:
    - name: /usr/local/www
    - target: /place/db/www
    - user: root
    - group: root
    - mode: 755

/coredumps:
  file.symlink:
    - name: /coredumps
    - target: place/coredumps
    - user: root
    - group: root
    - mode: 755

# RUNTIMECLOUD-5241
/skynet:
  file.symlink:
    - name: /skynet
    - target: /Berkanavt/supervisor/base/active
    - user: root
    - group: root
    - mode: 755

/usr/local/bin/sky:
  file.symlink:
    - name: /usr/local/bin/sky
    - target: /skynet/tools/sky
    - user: root
    - group: root
    - mode: 755

# RUNTIMECLOUD-5388
/etc/sudoers.d/yandex-search-user-loadbase-custom:
  file.managed:
    - user: root
    - group: root
    - mode: 440
    - contents:
      - 'loadbase ALL=(ALL) NOPASSWD: ALL'


/place/db/www/logs:
  file.absent:
    - order: last
