vm_packages:
  pkg.installed:
    - pkgs:
{%- if grains.lsb_distrib_codename == 'trusty' %}
      - cloud-init: "0.7.5-0ubuntu1.24"
{%- elif grains.lsb_distrib_codename == 'precise' %}
      - cloud-init: "0.6.3-0ubuntu1.26"
      - cloud-utils: "0.25-1ubuntu5.2"
      - gdisk
{%- elif grains.lsb_distrib_codename == 'xenial' %}
      - net-tools: "1.60-26ubuntu1"
      - acpid: "1:2.0.26-1ubuntu2"
      - ifupdown: "0.8.10ubuntu1.4"
      - isc-dhcp-client: "4.3.3-5ubuntu12.10"
      - cloud-init: "20.2-45-g5f7825e2-0ubuntu1~16.04.1"
{%- elif grains.lsb_distrib_codename == 'bionic' %}
      - net-tools: "1.60+git20161116.90da8a0-1ubuntu1"
      - acpid: "1:2.0.28-1ubuntu1"
      - ifupdown: "0.8.17ubuntu1.1"
      - isc-dhcp-client: "4.3.5-3ubuntu7.1"
      - cloud-init: "20.3-2-g371b392c-0ubuntu1~18.04.1"
{%- else %}
      - net-tools
      - acpid
      - ifupdown
      - isc-dhcp-client
      - cloud-init
{%- endif %}

/etc/network/interfaces:
  file.managed:
    - contents:
      - "source /etc/network/interfaces.d/*.cfg"

/etc/cloud/cloud.cfg.d/90_dpkg.cfg:
  file.managed:
    - require:
      - pkg: vm_packages
    - contents:
      - "# to update this file, run dpkg-reconfigure cloud-init"
      - "datasource_list: [ NoCloud, ConfigDrive ]"

/etc/cloud/cloud.cfg:
  cmd.run:
    - name: 'sed -i "s/^disable_root: \(true\|True\|1\)/disable_root: False/g; /^user: ubuntu/d" /etc/cloud/cloud.cfg'
    - require:
      - pkg: vm_packages

/etc/sysctl.d/30-eth0.conf:
  file.managed:
    - contents:
      - net.ipv6.conf.eth0.autoconf=0
      - net.ipv6.conf.eth0.accept_ra=0
      - net.ipv6.conf.eth0.dad_transmits=0
      - net.ipv6.conf.eth0.accept_dad=0

/usr/sbin/update-grub:
  file.symlink:
    - target: /bin/true

kernel_packages:
  pkg.installed:
    - pkgs:
      - linux-image-server: "4.19.100-23"
      - linux-tools: "4.19.100-23"
      - linux-image-generic: "4.19.100-23"
  cmd.run:
    - name: ln -sf boot/vmlinuz-4.19.100-23 vmlinuz; ln -sf boot/initrd.img-4.19.100-23 initrd.img
    - require:
      - pkg: kernel_packages
      - file: /usr/sbin/update-grub

/extlinux.conf:
  file.managed:
    - contents:
      - DEFAULT linux
      - LABEL linux
      - KERNEL vmlinuz
      - APPEND initrd=initrd.img root=LABEL=rootfs ro console=tty1 console=ttyS0,115200n8 loglevel=7 oops=panic panic=30 fsck.repair=yes

/etc/fstab:
  file.managed:
    - contents:
      - LABEL=rootfs    /    ext4    defaults,errors=panic    0 1
    {%- if grains['lsb_distrib_codename'] == 'trusty' %}
      - none    /run/shm    tmpfs   defaults    0 0
    {%- endif %}

# https://st.yandex-team.ru/RUNTIMECLOUD-8460
/etc/dhcp/dhclient-enter-hooks.d/resolved:
  file.absent:
    - order: last
