import json
import socket
import time


class Check(object):
    @classmethod
    def make_walle(cls, service, status, reason, tags=None):
        d = {
            'timestamp': int(time.time()),
            'reason': reason,
        }
        return cls(service, status, desc=json.dumps(d), tags=tags)

    def __init__(self, service, status, desc=None, tags=None):
        self.service = service
        self.status = status
        self.desc = desc
        self.tags = tags or []

    def to_event(self, hostname):
        return {
            "host": hostname,
            "service": self.service,
            "status": self.status,
            "description": self.desc,
            "tags": self.tags,
        }


def fmt_check_text(service, status, reason, tags=None):
    check = Check.make_walle(service, status, reason, tags=tags)

    return json.dumps({'events': [check.to_event(socket.gethostname())]})
