from infra.rtc.docker_registry.docker_torrents.clients.registry import RegistryClient
from infra.rtc.docker_registry.docker_torrents.clients.blackbox import BlackboxClient
from infra.rtc.docker_registry.docker_torrents.torrent_config import TorrentsConfig
from infra.rtc.docker_registry.docker_torrents.torrent_brewer import TorrentBrewer
from infra.rtc.docker_registry.docker_torrents.database import TorrentDatabase
from infra.rtc.docker_registry.docker_torrents.torrent_server import start
from infra.rtc.docker_registry.docker_torrents.clients.skyboned_helper import get_torrent_helper_from_config
import argparse


if __name__ == '__main__':
    parser = argparse.ArgumentParser(description='Process some integers.')
    parser.add_argument('-c', '--config', type=str,
                        default='/etc/docker-registry-torrents/config.yaml',
                        help='Config file (default '
                             '/etc/docker-registry-torrents/config.yaml)')
    parser.add_argument('-d', '--debug', type=bool, nargs='?',
                        default=False,
                        help='Enable debug mode in Flask')
    args = parser.parse_args()
    config = TorrentsConfig(args)
    registry = RegistryClient(config)
    database = TorrentDatabase(config)
    blackbox = None
    if config.blackbox is not None:
        blackbox = BlackboxClient(config)
    torrent_helper = get_torrent_helper_from_config(config.torrent_helper_config, logger=config.logger)
    brewer = TorrentBrewer(config, registry, database, blackbox, torrent_helper)
    start(config, brewer)
