from infra.rtc.docker_registry.docker_torrents.exceptions import SubrequestException
from infra.rtc.docker_registry.docker_torrents.torrent_config import TorrentsConfig
from requests import HTTPError
import requests


class TvmToolClient:

    def __init__(self, config: TorrentsConfig):
        self.url_template = config.tvm_tool.get('url_template', 'http://localhost:1/{payload}')
        self.auth = config.tvm_tool.get('auth')
        self.connect_timeout = float(config.tvm_tool.get('connect_timeout', 0.1))
        self.read_timeout = float(config.tvm_tool.get('read_timeout', 1))

    def get_ticket(self, destination: str) -> str:
        url_path = 'tvm/tickets?dsts={}'.format(destination)
        url = self.url_template.format(payload=url_path)
        with requests.request(
                method='GET',
                url=url,
                headers={'Authorization': self.auth},
                timeout=(self.connect_timeout, self.read_timeout)
        ) as response:
            try:
                response.raise_for_status()
                result = response.json()
                return result[destination]['ticket']
            except HTTPError as http_error:
                raise SubrequestException(http_error, response.text)
            except Exception as error:
                raise error
