from requests import HTTPError


class TorrentException(Exception):
    pass


class DublicateMapping(TorrentException):
    def __init__(self, digest: str):
        self.digest = digest

    def __str__(self):
        return 'Torrent mapping already exists digest: {}'.format(self.digest)


class InsufficientParametersException(TorrentException):

    def __init__(self, error: str):
        self.error = error

    def __str__(self):
        return self.error


class BlackboxException(TorrentException):

    def __init__(self, exception: str, error: str):
        self.exception = exception
        self.error = error

    def __str__(self):
        return 'Blackbox Authorization Error {}: {}'.format(self.exception, self.error)


class NoRoleException(TorrentException):

    def __init__(self, scope: str, role: str, login: str):
        self.scope = scope
        self.role = role
        self.login = login

    def __str__(self):
        return 'User "{}" has no role {} on {}'.format(self.login, self.role, self.scope)


class SubrequestException(TorrentException):

    def __init__(self, http_error: HTTPError, response: str):
        self.http_error = http_error
        self.response = response

    def __str__(self):
        return self.response
