import logging
import yaml
import sys
import os


class TorrentsConfig:

    def __init__(self, args=None):
        config_file = args.config
        self.debug_mode = args.debug

        config_data = dict()
        if config_file is not None and os.path.isfile(config_file):
            with open(config_file) as cfg:
                config_data = yaml.load(cfg)
        self.db = config_data.get('db', None)
        self.docker = config_data.get('docker_registry', None)
        self.blackbox = config_data.get('blackbox', None)
        self.mds = config_data.get('mds', None)
        self.torrent_helper_config = config_data.get('rbtorrent_helper', None)
        self.application = config_data.get('application', None)
        self.brewer = config_data.get('brewer', None)
        self.tvm_tool = config_data.get('tvm_tool', None)
        self.logger = logging.getLogger(__name__)
        self.logger.setLevel(logging.DEBUG)
        logger_stream = logging.StreamHandler(sys.stdout)
        logger_stream.setLevel(logging.DEBUG)
        formatter = logging.Formatter('%(levelname)-8s [%(asctime)-15s] %(message)s')
        logger_stream.setFormatter(formatter)
        self.logger.addHandler(logger_stream)
