"""
Docker Registry age status check.
"""
import yaml
import psycopg2
from juggler.bundles import as_check, Status, Event

CHECK_NAME = "query_age"
CONFIG_PATH = "/etc/docker-distribution.yml"


def get_query_age():
    with open(CONFIG_PATH, 'r') as docker_conf:
        conf_data = yaml.safe_load(docker_conf)
    PASS = conf_data["auth"]["yaauth"]["PSQLConfig"]["ConnStrings"][0].split(":")[2].split("@")[0]
    hosts = list()
    for conn_str in conf_data["auth"]["yaauth"]["PSQLConfig"]["ConnStrings"]:
        hosts.append(conn_str.split("@")[1].split(":")[0])
    HOSTS = ",".join(hosts)
    PORT = conf_data["auth"]["yaauth"]["PSQLConfig"]["ConnStrings"][0].split(":")[3].split("/")[0]
    DB = conf_data["auth"]["yaauth"]["PSQLConfig"]["ConnStrings"][0].split(":")[3].split("/")[1].split("?")[0]
    USER = conf_data["auth"]["yaauth"]["PSQLConfig"]["ConnStrings"][0].split(":")[1].split("/")[-1]
    CONN_STR = f"""
        host={HOSTS}
        port={PORT}
        dbname={DB}
        user={USER}
        password={PASS}
        target_session_attrs=read-write
    """
    QUERY_STR = f"""SELECT pid, age(clock_timestamp(), query_start),client_addr,  usename, query
FROM pg_stat_activity
WHERE query != '<IDLE>' AND query NOT ILIKE '%pg_stat_activity%' AND usename LIKE '{USER}' AND age(clock_timestamp(), query_start) > '00:30:00'
ORDER BY query_start asc;"""
    conn = psycopg2.connect(CONN_STR)
    cur = conn.cursor()
    cur.execute(QUERY_STR)
    res = cur.fetchall()
    cur.close()
    conn.close()
    return res


@as_check(name=CHECK_NAME)
def juggler_check():
    try:
        query_list = get_query_age()
    except Exception as e:
        return Event(Status.CRIT, f'failed to get query age: {str(e)}')
    q_len = len(query_list)
    if q_len > 0:
        top3 = [f'age: {i[1]}, user: {i[3]}, q: "{i[4]}"' for i in query_list[:min(3, q_len)]]
        msg = "\n".join(top3)
        return Event(Status.CRIT, f'TOP-3 query by age: {msg}')
    else:
        return Event(Status.OK, "query with age > 30min not found")
