Панель разделена на несколько блоков. Если на панели достаточно места, в левой верхней части каждого блока расположен анонс, например, для блока container это текст "%d pods active".

![](https://jing.yandex-team.ru/files/lspliner/Screen%20Shot%202021-08-23%20at%202.33.49%20PM.png)
**Блок container на порто-панели в дефолтном режиме для сервиса Няни**

Если не передать названия блоков в значении тега blocks, панель покажет все доступные блоки.
* container — общая информация об активных подах.
* cpu, gpu, memory и network — как под использует процессор, GPU, оперативную память и сетевой интерфейс.
* disk и volumes — как под использует дисковые устройства и расположенные на них тома.
* logs (есть только для подов Деплоя) — как из пода отгружаются логи.

Чтобы увидеть на панели что-то осмысленное, в контексте панели надо задать значения следующих тегов.
* itype.
* Для получения информации о подах Деплоя — stage, deploy_unit.
* Для получения информации о подах Няни — nanny, либо prj, ctype и tier. Второй способ опаснее первого потому, что несколько сервисов Няни могут отгружать сигналы с одинаковыми prj, ctype и tier.

Следующие теги (и некоторые другие) являются необязательными.
* wide — если передать `True`, панель постарается уместиться на одном экране широкого монитора. При этом с неё пропадут самые неважные графики.
* devices — список дисковых устройств для блока disk. По умолчанию будут показаны все дисковые устройства, по которым есть сигналы.
* volumes — список томов для блока volumes. По умолчанию будут показаны все тома, по которым есть сигналы.
* geo — список локаций, разделённый запятой или вертикальной линией. По умолчанию будет показана информация о подах из всех локаций. О роли разделителя говорится ниже.
* hosts — список fqdn-ов подов Няни или нод, на которых запущены под Деплоя, разделённый вертикальной линией. По умолчанию будет показана информация по всем подам.

Панель готовили для работы в одном из пяти режимов.
1. Мониторинг за состоянием конкретного пода. Гиперссылка на панель из Няни как раз открывает её в таком режиме. Режим активируется, если в теге host передать один fqdn.
2. Сравнение состояний подов. Каждому поду соответствует одна колонка. Режим активируется, если в теге host передать несколько fqdn-ов, разделённых вертикальной линией.
3. Мониторинг за множеством подов в разрезе локаций. Каждой локации соответствует одна колонка. В таком режиме панель открывается в Деплое. Активируется, если в теге geo передать несколько мнемоник, разделённых символом вертикальной линии, например, `geo=sas|man`.
4. Режим планирования ресурсов. Активируется, если в теге focus передать значение `planning`. В этом режиме панель тоже поделена по локациям, но на ней отображаются немного другие графики.
5. Дефолтный режим, в котором можно понять какие-то общие вещи про сервис. Активируется, если hosts не передан или равен `ASEARCH`, focus не передан или равен `monitoring`, geo не передан, содержит всего одну мнемонику или в качестве разделителя мнемоник используется запятая.

#### Блок container
Если не сказано иное, все сигналы на всех графиках порто-панели относятся к порто-контейнерам верхнего уровня. Такие контейнеры называются подами. Как только под признаётся активным, голован агент начинает забирать сигналы из его unistat-ручек и отгружать их в базу данных.

Самый простой сигнал — `counter-instance_tmmv`, и он всегда равен единице. Сигнал агрегируется в пространстве сложением; на графике `Active pods` это превращается в линию, которая показывает общее количество активных подов. Благодаря unistat-ручке под-агента Деплоя о состоянии его подов есть больше информации, поэтому вместо графика активных подов для них на панели показываются график `Failed pods` со сломанными подами и график `Performing pods` с запускающимися и запущенными подами.

![](https://yasm-img.s3.mds.yandex.net/6f87359b6cd395f8568673639fd4c35e.png)
**Блок container на порто-панели в дефолтном режиме для сервиса (деплой юнита) Деплоя**

Панель `Important events` показывает количество событий, которые случились с процессами внутри пода за единицу времени: сколько раз oom killer убил к-л процесс, сколько процессов запустилось (засчитываются также запуски баш-скриптов в хуках), сколько раз процессы получили сигнал, который завершает их с созданием core dump-а. Панель `Threads` показывает количество запущенных тредов по всем процессам внутри пода. Показанный на скриншотах сигнал вычисляется как среднее: `div(portoinst-thread_count_tmmv,counter-instance_tmmv)`.

<details><summary>Полный список сигналов этого блока.</summary>

Сигналы Порто:

* counter-instance_tmmv
* portoinst-starts_summ
* portoinst-ooms_slot_hgram
* portoinst-cores_total_hgram
* portoinst-thread_count_tmmv

Сигналы под-агента:

* unistat-condition_pod_in_progress_ahhh
* unistat-condition_pod_ready_ahhh
* unistat-condition_pod_failed_ahhh
</details>

#### Блок cpu
В этом блоке показана утилизация тредами сигруппы выделенной им квоты процессорного времени.

##### Мониторинг
На графике `CPU wait` показаны сигналы, говорящие о нехватке выделенной доли процессорного времени. Wait max и wait avg считаются по гистограмме `portoinst-cpu_wait_slot_hgram` и показывают долю времени, которую треды сигруппы среднего и наиболее загруженного подов сервиса были готовы к выполнению, но не выполнялись. Throttled max и throttled avg (сигнал `portoinst-cpu_throttled_slot_hgram`) показывают ту долю времени, которую треды не выполнялись потому, что исчерпали лимит. 

![](https://jing.yandex-team.ru/files/lspliner/Screen%20Shot%202021-08-23%20at%202.47.41%20PM.png)
**Блок cpu показывает общую информацию о подах подсета Деплоя в режиме для широкого экрана**

Эмпирическим путём установлено, что значение `portoinst-cpu_throttled_slot_hgram` выше 0.1 означает, что cpu лимит для пода установлен ниже уровня, который под может употребить. Для сервисов с живой нагрузкой это означает, что времена ответа выше, чем могли быть, возможно — в разы.

Утилизация показана в процентах от лимита для среднего (график `CPU usage avg`) и наиболее загруженного (график `CPU usage max`) пода сервиса и считается по гистаграмме `portoinst-cpu_limit_usage_perc_hgram`. Отдельным сигналом считается доля времени, которую треды выполнялись в kernel-mode (гистограмма `portoinst-cpu_system_limit_usage_perc_hgram`). Кроме погрешности измерения сигнала самой системой измерений, на погрешность этого сигнала влияет также ядро Линукса.
* Код ядра, вызванный в пользовательском треде, как правило выполняет только те операции, ради которых его вызвали. Однако, он может переключиться на ввод-вывод, причём не обязательно данных для собственного пода.
* Системный вызов `sched_yield` передаёт остаток доли процессорного времени другим готовым к выполнению тредам. Но эта доля будет засчитана сигруппе передающего треда.

Когда панель открывается в режиме мониторинга за одним подом, график `CPU wait` становится проще: на нём остаются один сигнал wait, один сигнал throttled и один сигнал wait по всем тредам ноды (сервера), на которой запущен под. Вместо двух графиков `CPU Usage` появляется один по этому поду.

##### Планирование ресурсов
На графике `CPU usage` показаны общее количество ядер, выделенное сервису в качестве гарантии (`portoinst-cpu_guarantee_slot_cores_tmmv`) и лимита (`portoinst-cpu_limit_slot_cores_tmmv`), и текущее потребление (`portoinst-cpu_usage_slot_tmmv`).

![](https://yasm-img.s3.mds.yandex.net/5ab81cde1e3894df61392675d4451c31.png)
**Блок cpu в режиме планирования ресурсов. Каждая колонка соответствует 1 ДЦ присутствия сервиса.**

График `CPU wait` остаётся без изменений.

<details><summary>Полный список сигналов этого блока.</summary>

Сигналы Порто:

* portoinst-cpu_wait_slot_hgram
* portoinst-cpu_throttled_slot_hgram
* portoinst-cpu_system_limit_usage_perc_hgram
* portoinst-cpu_limit_usage_perc_hgram
* portoinst-cpu_limit_slot_cores_tmmv
* portoinst-cpu_guarantee_slot_cores_tmmv
* portoinst-cpu_limit_slot_cores_tmmv

Сигналы ноды (железного сервера):

* cpu-wait_cores_hgram
</details>

#### Блок gpu
В этом блоке показана утилизация процессами сигруппы доступных поду GPU и их температура.

##### Мониторинг

Температура GPU показана в градусах Цельсия (гистограмма `portoinst-gpu_temperature_hgram`), а утилизация — в процентах от полной занятости памяти (`portoinst-gpu_memory_utilization_hgram`) и вычислительного устройства (`portoinst-gpu_utilization_hgram`). Как и в блоке cpu, утилизация посчитана в среднем (`GPU avg`) и для самого горячего или занятого устройства (`GPU max`). По количеству гистограммных сигналов на графике ##GPUS## считается количество GPU, доступных подам в каждом ДЦ.

В режиме наблюдения за конкретным подом температура и утилизация показываются отдельно по каждому GPU.

![](https://yasm-img.s3.mds.yandex.net/2ed58a98b51ba2152444a00d89f4a2ad.png)
**Температура и утилизация каждого доступного GPU в режиме наблюдения за конкретным подом**

##### Планирование ресурсов

Утилизация подсчитывается по вычислительному устройству. График `GPU count` показывает количество доступных юнитов, а график `GPU utilization` — суммарную утилизацию от этого числа.

#### Блок memory
В этом блоке показана утилизация процессами сигруппы выделенной им квоты оперативной памяти.

##### Мониторинг
Утилизация показана в процентах от лимита для среднего (график `Memory usage avg`) и наибольшего (график `Memory usage max`) пода сервиса и считается по гистаграммам `portoinst-anon_limit_usage_perc_hgram` и `portoinst-memory_unevictable_limit_usage_perc_hgram`. В обоих сигналах считается только unevictable-память, занятая страницами, которые операционная система не может сбросить на диск. Следует помнить, что если сигруппа заняла всю свою квоту unevictable-страницами, ОС сбросит на диск исполняемый код процессов, и передача управления будет требовать чтения с диска. Чтобы заранее увидеть такую ситуацию или определить её во время факапа, на панели показан график `Major page faults`. Ситуация будет сопряжена с высокой утилизацией квоты на дисковые операции.

![](https://yasm-img.s3.mds.yandex.net/4dbc6ea29ede9237835b0bf55a2053da.png)
**Так выглядит блок memory**

Отдельно считаются доли страниц, в которые отображаются файлы (unevictable file), и в которые не отображаются (unevictable anonymous). Если отображение файла в память выполнено без флага `MAP_LOCKED`, и страница не выведена в статус unevictable функцией `mlock`, такие страницы ОС может сбросить для освобождения памяти. Однако, вся память, которую процессы выделяют с флагом `MAP_ANONYMOUS`, — а это, например, стек и куча — в rtc выделяются без резервирования файлом подкачки. После нескольких инцидентов [в rtc появилось правило](https://clubs.at.yandex-team.ru/infra-cloud/1807), которое мешает процессам сигруппы занять всю квоту unevictable anonymous-страницами. Однако такого же правила для unevictable file-страниц нет.

Складывать unevictable file и unevictable anonymous не следует, ведь max может быть посчитан на разных серверах, и получится что сумма считается для процентов от разных величин. А от сложения средних по кластеру пользы и того меньше. Как тогда понять, в каком из подов кончилась память? На полях графика `Memory usage max` есть гиперссылка на панель, в которой квоты и утилизация показаны по хостам и в абсолютных цифрах. Гиперссылка скрыта в правом верхнем углу графика под символом `˅`. Сигнал `portoinst-memory_usage_gb_tmmv` на открывающейся панели показывает общий объём памяти, выделенный процессам пода, в том числе под evictable-страницы.

##### Планирование ресурсов
В режиме планирования ресурсов вместо графиков с долей утилизации появляется график `Anonymous memory usage (GB)`. С его помощью можно увидеть лимит и то, в каком диапазоне колеблется объем используемой unevictable anonymous-памяти.

![](https://yasm-img.s3.mds.yandex.net/ae43542340260f787ab232915f568712.png)
**У этого сервиса поды используют примерно равное количество памяти, и квантили лежат рядом**

<details><summary>Полный список сигналов этого блока.</summary>

Сигналы Порто:

* portoinst-memory_limit_slot_gb_tmmv
* portoinst-major_page_faults_summ
* portoinst-anon_limit_usage_perc_hgram
* portoinst-memory_unevictable_limit_usage_perc_hgram
* portoinst-memory_usage_gb_tmmv
* portoinst-anon_usage_gb_tmmv
* portoinst-memory_guarantee_slot_gb_tmmv
* portoinst-memory_limit_slot_gb_tmmv
* portoinst-memory_limit_slot_hgram
* portoinst-anon_usage_slot_hgram

</details>

#### Блок network
В этом блоке показана утилизация процессами сигруппы выделенной им квоты на передачу данных через сетевой интерфейс.

**NB1** На момент написания этой статьи сетевые квоты находятся в процессе внедрения, и статья описывает итоговую точку, а не актуальное состояние.

**NB2** Лимиты и гарантии контролируются Порто на виртуальном и физическом сетевом интерфейсах ноды, на которой запущен под. Однако, это не единственное место, где пакеты пода могут быть отброшены. Исходящие пакеты могут быть отброшены сетевым оборудованием. Известны случаи, когда из-за переподписки времена ответов некоторых подов при прочих равных условиях оказывались выше. Чтобы располагать ясной картиной, мы рекомендуем сервисам иметь сигналы, указывающие на производительность отдельных подов; для сервисов, принимающих живую нагрузку, это будут rps-ы и времена ответов.

##### Мониторинг

Утилизация показана в процентах от лимита для подов со средней (график `Network usage avg`) и наибольшей (график `Network usage max`) утилизацией сетевого интерфейса и считается по гистаграммам `portoinst-net_rx_utilization_hgram` и `portoinst-net_tx_utilization_hgram`. Когда под приближается к стопроцентной утилизации, пакеты во входящей (RX) или исходящей (TX) очередях могут начать отбрасываться (drop). Однако, пока вся полоса ноды не занята, скорее всего, это не произойдёт.

![](https://yasm-img.s3.mds.yandex.net/261c99588baa995bcabc23ef464649ab.png)

##### Планирование ресурсов

В режиме планирования ресурсов вместо утилизации в процентах панель начинает показывать общий объем данных, передаваемый (`portoinst-net_tx_mb_summ`) и принимаемый (`portoinst-net_rx_mb_summ`) подами сервиса. Выделенные сервису гарантия (`portoinst-net_guarantee_mb_summ`) и лимит (`portoinst-net_limit_mb_summ`) будут в равных долях распределены между всеми подами.

<details><summary>Полный список сигналов этого блока.</summary>

Сигналы Порто:
* portoinst-net_rx_utilization_hgram
* portoinst-net_tx_utilization_hgram
* portoinst-net_rx_mb_summ
* portoinst-net_tx_mb_summ
* portoinst-net_guarantee_mb_summ
* portoinst-net_limit_mb_summ
* portoinst-net_rx_drops_summ
* portoinst-net_tx_drops_summ
* portoinst-net_rx_utilization_tmmv
* portoinst-net_tx_utilization_tmmv

</details>

#### Блок logs
Мониторинг за unified-агентом встроен в под-агент Деплоя, поэтому блок и соответствующие сигналы будут только у подов Деплоя. Блок предельно простой: если отгрузка логов идёт, то на графике `Transfer` показана скорость отгрузки, а если не идёт, но должен, то на графике `Problems` могут проскакивать ненулевые значения.

![](https://yasm-img.s3.mds.yandex.net/0f0a844fd5f2e2f55ea80046d242051e.png)

<details><summary>Полный список сигналов этого блока.</summary>

Сигналы под-агента:
* unistat-pod_agent_logs_transmitter_transfered_raw_logs_deee
* unistat-pod_agent_logs_transmitter_lost_logs_rotated_by_pod_agent_deee
* unistat-pod_agent_logs_transmitter_lost_logs_rotated_by_porto_deee
* unistat-pod_agent_logs_transmitter_num_of_session_activation_errors_deee

</details>

#### Блоки disk и volumes
Дисковая память как ресурс имеет два аспекта: утилизация шины, по которой данные перемещаются между оперативной памятью и конкретным блочным устройством, и утилизация свободного места на этом блочном устройстве. Если точнее, то даже не на блочном устройстве, а на томе, то есть на размеченной логической файловой системе, которая хранится на этом блочном устройстве. Соответственно, сигналы в блоке disk указывают на утилизацию шины, а в блоке volumes — на утилизацию томов.

![](https://yasm-img.s3.mds.yandex.net/5035d46911eb624757edc5da84666b06.png)

В блоке disk три графика: `IO Wait` и два графика, показывающие насколько интенсивно процессы пода читают и пишут с дискового устройства. Все сигналы разделены в зависимости от того, к какому устройству обращена операция. Устройство `/place` обозначает жесткий диск или RAID-массив, а устройство `/ssd` — SSD или NVME. На графике IO Wait показана доля времени, которую команды на чтение (`portoinst-io_wait_time_{УСТРОЙСТВО}_read_hgram`) и запись (`portoinst-io_wait_time_{УСТРОЙСТВО}_write_hgram`) ожидают выполнения; синхронные команды блокируют выполняющие их процессы.

Сигнал Throttled (`portoinst-io_throttled_time_%s_total_hgram`) на графике `IO Wait` указывает на то, что операции ожидают выполнения в связи с достижением лимита квоты. На момент написания статьи квотируются только операции чтения. По этой причине утилизация квоты операциями чтения показана в процентах от лимита, а операциями записи — в абсолютных величинах.

В блоке `volumes` про каждый том показана доля свободного места.
