# Project ID
Для работы в multi-tenancy сегментах облачных платформ (с одним VLAN на всех) необходимо выделить уникальный project-id.
Выделяемый ID является company-wide идентификатором вашего проекта, т.е. ассоциируется с одной и той же сущностью на любых платформах.

Необходимые составные части проекта в этой схеме следующие:

* Собственно сам ID, он встраивается в IP адрес ваших машин, подробнее про это можно почитать [по этой ссылке](https://wiki.yandex-team.ru/NOC/newnetwork/hbf/project_id/)
* Макрос файрволла, чтобы сослаться на новый project ID в правилах файрволла
* Секция файрволла, в которой будут описываться дырки до проекта

## Описание формы
В RackTables существует [форма](https://racktables.yandex.net/index.php?page=services&tab=projects), в которой можно выделить проект с необходимыми параметрами.
Форма предлагает ввести следующую информацию для нового проекта:

* Имя макроса
**Обязательное поле**. Нужно указать имя макроса, в который будут включены все сети проекта.
Правила именования нового макроса: `/^_[A-Z0-9_]+NETS_$/`, т.е. допустимы латинские символы в верхнем регистре, цифры и символ нижнего пробела (`"_"`), причем все имя макроса должно кончаться на "NETS" и быть обязательно обрамлено символом нижнего пробела (ex. `_MACRONETS_`)
Указанный макрос будет создан автоматически, если он не существовал до этого.
Так же на основе имени макроса будет создана секция файрволла (путем усечения обрамляющих символов "_"), так же если она не существовала до этого
Если указать существующий макрос, то будет произведена проверка ваших прав на редактирование привязанной к макросу секции. Если у вас имеются нужные права - project_id будет привязан к указанной секции, если прав нет - будет выдано соответствующее сообщение.
* Ответственные за секцию.
Необязательное поле. Сюда можно сразу прописать всех ответственных за редактирование созданной секции файрволла.
Распознаются логины и стафф-группы (url), разделители: /[,\s]/. Обратите внимание, что У групп сервисов ABC тоже есть стафф-url. Примеры:
```
alan
yandex_mnt_noc
svc_vertistat_services_management
```

После подтверждения введенной формы, будет создан project-id и, если необходимо, нужная секция и макрос. Сразу после этого можно перейти в секцию и приступить к добавлению в нее нужных дырок.
Project ID номер будет выбран автоматически - это будет первый свободный номер после 0x500.

## Редактирование
Если вы имеете права на секцию project_id, то вы можете удалять проект и редактировать некоторые его свойства.

## Дополнительно
Структура проектов древовидна. Это позволяет макросам создаваемых проектов включаться в макросы проектов-родителей, если нужно.
Включать проект в другой проект может только человек, имеющий права редактирования на оба этих проекта.

## Время раскатывания
Изменения раскатываются через HBF с его SLA. На момент написания этих строк HBF катится податацентрово. График раскатки можно смотреть в [firewall](https://firewall.yandex-team.ru/).
Но надо понимать, что ревизия варится тоже не моментально. В целом окно выезда изменений на всю сеть - порядка 3 часов. Некоторое время требуется для появления макроса в форме выбора сетевого макроса.
