# Требования к сервисам

Для того чтобы ваш сервис смог комфортно жить в облаке стоит ознакомиться с рядом требований к нему.

## Доступность

{% note alert %}

Эти требования необходимо учитывать чтобы сервис оставался доступным.

{% endnote %}

Доменами отказа (failure domain) облака являются сервер, стойка, ДЦ. Датацентры выходят из строя по разным причинам. Может пропасть питание и АВР с дизелями не спасают, периодически требуется выполнять [регламентные работы](https://wiki.yandex-team.ru/capacity-planning-team/drills/). Стойки так же страдают от проблем с питанием или из-за необходимости проводить регламенты. Сервера выходят из строя десятками разных способов и так же как и всё остальное требует обслуживания, например, для ребута ядра. В конце концов на сервис нужно выкладывать новую версию.

Поэтому необходимо поднимать достаточное кол-во подов вашего сервиса (pod set) чтобы пережить такие отказы. Pod set считается доступным, если среди включенных подов сетевая связность утрачена у не более, чем N подов, где N равно бюджету недоступности pod set, pod set должен удовлетворять следующим условиям:
- имеет бюджет недоступности 1 или более; 
- имеет менее 20 подов, либо имеет бюджет недоступности 5% от числа инстансов или более; 
- имеет не менее 3 включенных подов;

## Миграция подов

В YP базовой сущностью планирования является контейнер, он же под (pod). У каждого пода есть уникальный идентификатор — `pod_id`.
Планировщик селит поды на ноды, где есть достаточное число ресурсов для размещения. Не всегда ресурсы есть прямо сейчас, поэтому есть моменты времени, когда у пода нет ноды, в этом случае под находится в состоянии ожидания. При этом существуют [ограничения](https://wiki.yandex-team.ru/yp/scheduling/guarantees/public/) на гарантии планирования в YP. [Подробнее про объектную модель в YP.](https://wiki.yandex-team.ru/yp/YP-Quick-start-guide/)

Когда под живет на ноде, а нода вдруг выходит из строя — мы должны перенести все поды с умершей ноды на живую. Плюс какой бы идеальный алгоритм планирования YP ни использовал, всегда есть процесс создания-удаления подов, который фрагментирует кластер, поэтому YP будет периодически пытаться улучшить состояние кластера, выполняя дефрагментацию, перенося поды в более подходящее место.

Во всех таких случаях выполняется миграция подов.

### Как происходит миграция подов

Когда YP принимает решение о переносе пода на другую ноду, инициируется протокол эвакуации. Для этого YP устанавливает у пода специальный флаг, "запрос на перемещение» (eviction_request). Управляющие системы (Nanny, Деплой, QYP) выполняют подготовительные действия для переноса (делают бекапы, проверяют текущую живость сервиса), после чего или самостоятельно копируют поды или просят YP под передвинуть.

Таким образом политики миграции определяются не YP, а управляющими системами. И в разных системах, YP.Lite, QYP, Яндекс.Деплой, политики миграции разные.

#### Виды миграций в YP.Lite

YP.Lite поддерживает миграции:

* move;
* copy and remove.

##### Move

Под переносится с одной ноды на другую с сохранением pod_id. Данные из контейнеров не переносятся, в новом месте контейнер создается заново. Во время переноса сервис работает в n-1 реплике.

Это наиболее типичный сценарий, который подходит большинству сервисов.

Плюсы:

* pod_id постоянны, значит постоянные FQDN, постоянные файлы конфигураций;
* Так как pod_id не меняется, то при переезде пода в Няне не создаются дополнительные снепшоты (это может быть важно для больших сервисов).

Минусы:

* Под сначала удаляется, а только потом ищется для него новое место, поэтому возможна задержка, если подходящая нода не нашлась сразу.

Так как pod_id не изменяется, то и FQDN пода не изменяяется, но IP-адрес пода зависит от ноды, поэтому IP-адрес при каждом переезде будет уже новым. Это приводит к морганию старый-новый IP-адрес пода на некоторое время.

##### Copy and remove

Сначала создается новый под с новым pod_id, активируется, после чего старый под удаляется. Во время переноса сервис работает в n+1 реплике.
Так как при миграции сначала создается новый под, а только потом удаляется старый, то время «нестабильности» сервиса из-за переключения минимально. Во время переезда используется временная коммунальная квота, наличия собственной свободной квоты не нужно, но так как квота общая, она может быть занята и это увеличит время переезда.

Плюсы:

* Так как во время переключения активны старые и новые поды одновременно, можно реплицировать данные между старым и новым подом (конечно, если нода умерла, то так уже нельзя). Данные переносить можно вручную или автоматически;
* Сервис не деградирует ниже n реплик (опять же если нода не умерла, конечно).

Минусы:

* новый идентификатор pod_id и новый FQDN на каждый переезд (сложнее разбираться в логах);
* новые снепшоты в Няне на каждый переезд (если у вас большой сервис и вы живете в старом ДЦ, вам это может оказаться важно).

###### Ручная и автоматическая активация контейнеров

При автоматической активации создается новый под, в нем вызывается install_hook/prepare_hook/start_hook. Далее Няня ожидает перехода нового пода в состояние Active, после чего удаляет исходный под. Тайм-аутов на переключение нет.

При ручной активации создается новый под, вызываются install_hook/prepare_hook, опционально ожидается подтверждение оператора сервиса, после чего вызывается start_hook. В этот момент активны n+1 под (все старые поды плюс один новый). После перехода нового пода в состояние ACTIVE, Няня опционально ожидает ручного подтверждения оператора и переводит старый под в состояние PREPARED, после чего его удаляет.

#### Яндекс.Деплой

За перенос подов в Яндекс.Деплое отвечает специальный сервис — ReplicaSetController. ReplicaSetController отслеживает параметры деградации сервисов и всегда переносит поды автоматически.

Для переноса stateless и statefull сервисов используются различные политики.

#### QYP

При получении запроса на миграцию, QYP дожидается наступления ночи, после чего выполняет backup виртуальной машины в sandbox. Когда backup завершается, QYP переносит под в новое место, где восстанавливает виртуальную машину из backup’a.

### Как найти свои контейнеры после миграции

{% note alert %}

Мы рекомендуем не использовать DNS для получения IP-адресов своих подов вообще, кроме как для операций логирования.

{% endnote %}

В YP есть стандартный способ нахождения контейнеров — Service Discovery (SD). SD очень похож на DNS, только без кэширования и с дополнительными метаданными.

У каждого пода в YP есть два FQDN: постоянный, который не меняется при передвижении контейнеров, и переменный, который изменяется каждый раз. DNS не очень подходит для систем, где компоненты активно передвигаются так как DNS кэширует IP-адреса на разных уровнях и после переезда постоянный FQDN начинает моргать, указывая то старый, то новый IP-адрес на протяжении какого-то времени. Кардинально на это повлиять нельзя так как кэширование многоуровневое, в разных системах.

В модели YP за обнаружение инстансов отвечает резолвинг EndpointSetа в список Endpoint’ов, когда по идентификатору сервиса возвращаются пары (IP-адрес, fqdn, порт, список labels). Эти данные похожи на список подов и их IP-адресов, но отличаются тем, что у одного пода Endpoint'ов может быть несколько. Кроме этого, могут быть разные правила создания Endpoint'ов. Например, Endpoint-ы для мониторинга или Endpoint'ы для шардов, у которых может быть разный жизненный цикл и разные политики создания.

### Federated.SD

Если каждый из полутора миллионов контейнеров облака будет для SD ходить в мастера YP, YP будет очень сильно нагружен. Для снижения нагрузки на мастера все данные для SD кэшируются в отдельном сервисе — Federated.SD. Этот сервис кэширует и оперативно обновляет все данные о Endpoint'ах. В каждой локации поднято несколько реплик Federated.SD, с суммарной скоростью работы до нескольких миллионов RPS.

Для работы с Federated.SD мы подготовили библиотеки для [С++](https://a.yandex-team.ru/arc/trunk/arcadia/infra/yp_service_discovery/libs/client) и для [Python](https://a.yandex-team.ru/arc/trunk/arcadia/infra/yp_service_discovery/python/resolver). Для С++ есть еще одна, [более лучшая библиотека](https://a.yandex-team.ru/arc/trunk/arcadia/infra/yp_service_discovery/libs/sdlib), которая кэширует данные локально между перезапусками и обновляет результаты в фоне.

### Как часто будет происходить миграция

Миграция подов — дорогая операция как для сервисов, так и для YP, поэтому мы стараемся уменьшить частоту миграций подов.

Управляющая система (Nanny, Деплой, QYP) самостоятельно контроллируют частоту переноса подов и разрешает сервисам это настраивать. Настройки по-умолчанию выставлены, чтобы не выполнять миграцию чаще, чем раз в час. Такое значение в основном нужно для аппаратных сбоев. В случае дефрагментации кластера мы стремимся не инициировать миграцию чаще, чем раз в неделю на сервис и пока не видим причин это выполнять чаще.

### FAQ

#### Какой тип миграции мне использовать

Лучше всего использовать move. Режим copy and replace в основном предназначен для поддержки переноса данных в statefull сервисах.

#### Как часто мои поды будут переносить

Не чаще, чем указано в настройках самого сервиса. Обычно это не чаще, чем раз в час и это нужно для оперативной реакции на аппаратные сбои. Дефрагментация кластера планируется не чаще раза в неделю на сервис.

#### Мой сервис можно переносить только руками, миграция отключена. Я молодец?

Если для ITDC нужно забрать хост, но в сервисе отключена миграция, нельзя бесконечно ждать пока сервис все-таки съедет.

Мы даем семь дней с начала запроса на миграцию сервисам, чтобы переехать, после чего хост отдается в ITDC. Мы планируем сокращать разрешенное время на переезды сервисов каждый квартал: в Q3 мы даем неделю, в Q4 — пять дней, в 2020.Q1 — 3 дня и т.д.

#### Почему не нужно использовать DNS

FQDN в DNS кэшируется на различных промежуточных серверах, в итоге при миграции FQDN начинают моргать старый-новый IP-адреса и управлять этим нельзя. Используйте YP.Service Discovery.

#### Я под AppHost, что мне надо делать

Apphost умеет самостоятельно резолвить EndpointSet’ы через YP.Service Discovery, это выполняется раз в десять минут, все работает само.

#### Поддерживается ли YP.SD в балансерах и прокси-серверах?

Awacs умеет резолвить EndpointSet’ы в файлы конфигурации балансеров и прокси. Нативная поддержка Service Discovery в балансерах и прокси-серверах встраивается прямо сейчас, ждем релиза в ближайшее время.

#### У меня кросс-ДЦ сервис, могут ли меня начать двигать в разных ДЦ одновременно

Если у вас кросс-ДЦ сервис, объединяющий разные локаций в одном Няня-сервисе, то одновременных миграций между ДЦ не будет, управляющая система, Няня, это учитывает. Однако мы очень не рекомендуем так делать. При любом сбое одного ДЦ останавливается деплой сразу во всех локациях. Более правильная поддержка кросс-ДЦ сервисов будет в Яндекс.Деплое.

#### Переносятся ли данные при миграции подов

Данные переносятся только в QYP так как там выполняется полный backup виртуальной машины. В остальных системах данные не переносятся. Поломка хостов возможна всегда и сервисы должны уметь самостоятельно восстанавливать свои состояния из хранилищ данных или за счет репликации с соседних сервисов.
