# Первая линия
Данный документ описывает регламенты взаимодействия объединенной поддержки RTC (RTCSUPPORT) с пользователями. Он разделен на две части:

- пользовательскую, которой нужно следовать пользователям RTC, чтобы претендовать на обработку обращений в рамках SLA
- внутреннюю, выполнение которой командой RTC обеспечивает обработку обращений в рамках SLA.

Обе части приводятся в одном документе, т.к. пользователям во многих случаях полезно знать как работают наши внутренние механизмы.

В большинстве случаев внутренние части скрыты под спойлером.

## Обзор инструментов для создания и обработки обращений
### Основные системы для обращений в RTCSUPPORT
- Telegram чат [rtcsupport](https://t.me/joinchat/Be0kOD50fVxMoi_8hPvG6Q)
- Очередь в Star Trek [st/RTCSUPPORT](https://st.yandex-team.ru/RTCSUPPORT)

### Системы для автоматизации заведения и обработки обращений:
- [Tickenator UI](https://tickenator.z.yandex-team.ru/#/rtc) для заведения обращения в очередь RTCSUPPORT
- Telegram bot YaIncBot заведение тикетов по команде /newticketrtc
- Wabbajack – система для автоматического сбора диагностики в зависимости от полноты входных данных в обращении (имя сервиса, имена хостов, примерный тег проблемы)

## Работа с telegram чатом RTCSUPPORT
Основной системой для обращений в RTCSUPPORT является telegram чат. Обращения в данном чате составляются пользователями в свободной форме и могут содержать следующие вопросы:

- Проблемы деплоя конкретного сервиса
- Проблемы с серверами (хостами) облака
- Вопросы о настройке инфраструктурных компонент (pushclient, instancectl, ротирование логов, работа с секретами, etc...)
- Вопросы о регламентных работах
- Сетевые доступы и роли через IDM
- Вопросы о работе KVM в RTC (QYP)

### Требования к обращению в чат RTCSUPPORT
Для соблюдения временных SLA на обработку обращения пользователя и для более эффективного решения проблемы обращение в чат должно содержать:

- Четко обозначенную проблему (релиз, выход из строя оборудования) или задачу которую пользователь пытается решить
- Информацию о сервисе пользователя (ссылку на сервис в nanny, имя оборудования с которым возникли неполадки, ссылки на графики, которые могут помочь в решении проблемы)
- Оценку критичности проблемы (блокер, критичная, средняя)
В дальнейшем данная информация должна быть добавлена в обращение, если такое заведено.

## Оценка критичности проблемы

**Приоритет** | **Критерии**
--- | ---
Блокер | Проблема видна внешним пользователям, страдают процессы, денежные потери
Критичный | Затронута большая часть инфраструктуры. Может перерасти в проблему заметную снаружи. Нарушает процессы/работу широкого круга подразделений Яндекса.
Средний | Проблема отдельной части инфраструкты, видна только внутреним пользователям, не блокирует работу подразделений, незначительно влияет на процессы.
Низкий | Проблемы с единичным проявлением не влияет на процессы, не затрагивает работу подразделений(может затрагивать работу одного человека)
Незначительный | Не срочные проблемы, консультации. Не влияют на процессы и работу.

### Дежурства по приему обращений в чате
Прием и разбор обращений в чате RTCSUPPORT осуществляет выделенный инженер поддержки. Какой именно - можно узнать из [календаря дежурств](https://calendar.yandex-team.ru/embed/week?&layer_ids=838003&tz_id=Europe/Moscow&layer_names=RTCSUPPORT_2nd_line).

В процессе дежурства инженер осуществляет прием обращений, их первоначальную классификацию и формирует ответ, если разбор обращения можно осуществить в чате. Обработка обращений осуществляется:

* уровня критичности блокер: круглосуточно
* уровней критичности средний и критичный: с 10:00 до 21:00 по рабочим дням.

{% cut "Процесс обработки обращения в чате:" %}

- Максимальное время от публикации обращения в чате до реакции на него со стороны поддержки составляет 10 минут.
- При приеме в работу обращения необходимо примерно оценить временные затраты на его обработку. Если время не превышает 10ти минут и обращений от других пользователей в данный момент нет, то обработка и ответ пользователю осуществляется в чате без заведения тикета в очереди RTCSUPPORT.
- Если обработать обращение в течение 10 минут возможности нет или параллельно поступили обращения от нескольких пользователей, следует завести по каждому обращению тикет в очередь RTCSUPPORT и сказать пользователю, что дальнейший разбор его обращения будет проходить в тикете.
- В ситуации, когда в чат приходят несколько обращений параллельно:
- производится отбор более затратных по времени обращений и заведение по данным обращениям тикетов в RTCSUPPORT
- остальные обращения разбираются в чате без заведения тикета.


- Приоретизация и первоначальная оценка трудоемкости обработки сообщения проводится дежурным инженером, не должна превышать 15 минут на одно обращение.

{% endcut %}

## Работа с очередью RTCSUPPORT
### Заведение обращения пользователем
Заведение обращения в RTCSUPPORT настоятельно рекомендуется проводить через форму, доступную  по [ссылке](https://tickenator.z.yandex-team.ru/#/rtc) , заведение через данную форму гарантирует более полное заполнение необходимых полей тикета, которые в свою очередь нужны для ускорения обработки тикета.

{% cut "Далее приведен примерный перечень необходимой информации и требования к оформлению:" %}

1) Заголовок тикета должен, как можно полнее отражать суть проблемы, в идеальном случае из заголовка инженер должен понять:
– Примерную область или компонент инфраструктуры, где возникла проблема
– Критичность данной проблемы для внешних и внутренних пользователей
– Продукт и сервис, к которому относится проблема
1) Приоритет обращения определяется пользователем, в первую очередь, исходя из влияния на внешних пользователей, затем на внутренних. Желательно выбирать приоритет, который будет адекватен проблеме. Правильно выбранный приоритет гарантирует правильное оповещение инженеров, которые займутся решением проблемы.
1) Описание должно содержать всю уточняющую информацию, далее примерный перечень той информации, которая требуется инженеру для начала работы по обращению:

- Ссылка на сервис в интерфейсе управления облаком (Nanny)
- Hostname проблемного сервера (если возможно его локализовать)
- Графики и критичные проверки сервиса
- Логи сервиса

{% endcut %}

Желательно не перегружать описание диагностикой, если проблема не локализована до конкретного компонента инфраструктуры.

### Обработка обращения
Обработкой обращений(тикетов) в очереди RTCSUPPORT занимается выделенный инженер поддержки, узнать текущего дежурного инженера можно из [календаря](https://calendar.yandex-team.ru/embed/week?&layer_ids=838003&tz_id=Europe/Moscow&layer_names=RTCSUPPORT_2nd_line).

#### Процедура обработки сообщения 1 линией поддержки
Инженер самостоятельно определяет порядок разбора обращений в очереди, при этом учитывая, что максимальное время принятия в работу нового обращения (в статусе Открыт)
не должно превышать трех часов.

- На момент просмотра очереди обращение находится в статусе “открыт”
- Далее дежурный инженер 1 линии перед началом разбора переводит обращение в статус “В работе” и ставит себя исполнителем тикета
- Осуществляется локализация компоненты инфраструктуры, в которой возникла проблема, и собирается начальная (первичная диагностика)
- Проводятся работы по устранению проблемы.

В случае, если требуется передать обращение другому инженеру или эскалировать его на 2 или 3ю линию поддержки, инженер должен приложить все результаты диагностики и разбора обращения, данное действие минимизирует необходимость повторной работы.

Ответственным за решение тикета является инженер, который стоит в поле исполнитель в обращении.

Если решить проблему или точно ответить на вопрос в обращении силами 1 линии возможности нет, проводиться процедура эскалации обращения на 2ю линию. (см. Процедура эскалации обращения на 2ю линию).

В случае, если инженер может локализовать точную компоненту или участок инфраструктуры, в котором возникла проблема, обращение можно эскалировать на 3 линию, конкретному ответственному за компоненту или участок (см. Процедура эскалации обращения на 3ю линию).

Если заведенное обращение содержит в себе неполную информацию, инженер 1 линии переводит обращение в статус “Требуется информация” и проставляет исполнителем пользователя, который завел обращение для уточнения всех необходимых деталей. Ответить на вопрос инженера необходимо в течении одних суток. В случае отсутствия ответа, инженер призывает пользователя в тикет с уведомлением о необходимости предоставить информацию. В случае непредоставления информации еще в течение суток, инженер призывает руководителя пользователя в тикет, а в случае отсутствия ответа в течение еще одних суток, закрывает обращение с резолюцией "Нет реакции".

После того, как проблема решена (и пользователь это подтвердил), обращение переводится в статус “Закрыт” с резолюцией “Решен”, инженер 1 линии оставляет подробное описание проблемы, если из описания и комментариев оно не ясно, проставляет поля: Теги, Компонент. Каким образом заполнять поля описано на [соотвествующей странице](./ticket-markup.md).

#### Процедура эскалации обращения на 2ю линию
В случае если решить вопрос/проблему силами 1й линии не получается, инженер 1 линии должен эскалировать проблему на вторую линию поддержки.

Для эскалации обращения инженеру 1й линии требуется:

- Определить область/компоненту, где возникла проблема (насколько это позволяет опыт и полнота информации о проблеме)
- Добавить в обращение всю диагностику, которую удалось собрать в ходе решения проблемы (логи, графики, etc)
- Найти текущего дежурного 2й линии. Календари дежурств преведены на [данной странице](./responsibility.md). В зависимости от предметной области проблемы, возможен выбор дежурного по конкретной части инфраструктуры.
- Передать обращение дежурному 2й линии и получить подтверждение того, что человек взял обращение в работу. Исполнителем с данного момента становится дежурный 2й линии.

В случае если эскалация во вторую линию была преждевременной то стоит навесить тэг `returned_to_the_2_line` на тикет. На регулярной встрече поддержки такие тикеты будут отсматриваться, найти их можно с помощью [фильтра](https://st.yandex-team.ru/issues/402629).

#### Градация приоритетов, времена реакции и решения
##### **Времена реакции в рабочее время с 10:00 до 21:00**
**Приоритет**| **Открыт** | **Диагностика** | **1 Линия** | **2 Линия** | **В работе**| **Требуется инфрмация** | **Общее время**
--- | --- | --- | --- | --- | --- | --- | ---
Блокер | 5 минут | 10 минут| нет(тикет сразу переводится в работу) | нет(тикет сразу переводится в работу) | 4 часа | нет, вопросы уточняются оперативно в ходе решения | 4.15 часа
Критичный | 5 минут | 15 минут | 5 минут | 5 минут | 8 часов | нет, вопросы уточняются оперативно в ходе решения | 8.30 часа
Средний | 1 час | 4 часа | 30 минут | 30 минут | 72 часа | 48 часов(в случае не ответа закрывается) | 127 часов(5 дней)
Низкий | 1 час | 4 часа | 30 минут | 30 минут | 120 часов(5 дней) | 48 часов(в случае не ответа закрывается) | 182 часа(7 дней)
Незначительный | 1 час | 4 часа | 30 минут | 30 минут | 168 часов(7 дней) | 48 часов(в случае не ответа закрывается) | 223 часа(9 дней)

##### **Времена реакции в нерабочее время**
**Приоритет**| **Открыт** | **Диагностика** | **1 Линия** | **2 Линия** | **В работе**| **Требуется инфрмация** | **Общее время**
--- | --- | --- | --- | --- | --- | --- | ---
Блокер | 5 минут | 10 минут| нет(тикет сразу переводится в работу) | нет(тикет сразу переводится в работу) | 4 часа | нет, вопросы уточняются оперативно в ходе решения | 4.15 часа
Критичный | 5 минут | 15 минут | 5 минут | 5 минут | 8 часов | нет, вопросы уточняются оперативно в ходе решения | 8.30 часа

Обработка обращений в нерабочее время осуществляется через дежурную смену [MARTY](https://wiki.yandex-team.ru/jandekspoisk/sepe/dezhurnajasmena/) текущим дежурным. **Призвать дежурного в канале RTCSUPPORT возможно командой /marty для Ya.inc Bot.**

## Приложение
{% cut "Workflow обращений" %}

![rtcq_workflow-2.png](https://jing.yandex-team.ru/files/dvsonin/rtcq_workflow-2.png)

{% endcut %}

{% cut "Workflow консультации" %}

![consultation_workflow.png](https://jing.yandex-team.ru/files/naumbi4/consultation_workflow.png)

{% endcut %}
