# Вторая линия
В данном документе описана логика выбора соответствующей команды RTC в случае возникновения вопросов ко второй линии.

## Мотивация
* Доносить проблему сразу до той команды, что должна её либо решить, либо сформировать корректный workaround
* Получить регламент по роутингу обращений внутри службы

## Зоны ответственности
Зоны ответственности в этом документе уточняют какой именно команде RTC нужно адресовать вопросы из [RTCSUPPORT](./first-line.md). Если имеет место инцидент и нужна помощь 2-й линии, то выбирать команду нужно соответствующим образом. Аналогичная информация доступна в формате [таблицы](./responsibility.md).

Ожидается, что:

* в случае вопроса в тикет из очереди RTCSUPPORT должен быть призван дежурный конкретной команды (или дежурные нескольких команд в случае проблем на стыке)
* в каждой из зон ответственности существуют типовые проблемы и не все из них можно системно починить в разумные сроки
* типовые проблемы, с которыми часто приходится сталкиваться сервису описаны в базе знаний первой линии при условии что первая линия имеет возможность эту проблему локально зачинить / предложить workaround
* типовые проблемы видны на стандартных мониторингах хоста / сервиса что исключает некорректную диагностику

Регламент работы с очередью RTCSUPPORT описан в соответствующем [документе](./first-line.md), здесь же зафиксирован роутинг обращений. Регламент действий при инцидентах описан [здесь](./incidents-handling.md).

Далее следует короткое описание зон ответственности службы базовой инфраструктуры вместе с примерами проблем из реальной жизни, как их видят пользователи.

### Wall-E
[Команда](https://abc.yandex-team.ru/services/wall-e/duty/) обеспечивает доступность и работоспособность серверов (только самих серверов, за инфраструктурные компоненты, работающие на серверах, ответственны другие команды) облака, координирует проведение плановых работ над серверами или стойками.

* Недоступные или неуправляемые железные хосты: недоступный ssh, спонтанные ребуты хостов
* Проблемы с железом у серверов: битые диски, память, CPU, GPU, взаимодействие с hw-watcher, новый вариант сбоя железной компоненты сервера, влияющий на пользователя
* Хосты не чинятся (проблема видна): хост ожидает разрешения у оркестратора на починку
* Взаимодействие с ITDC или NOC в случае работ над хостами
* Создание проектов

### HostManager
[Команда](https://abc.yandex-team.ru/services/hostmanager/duty/) управляет конфигурацией серверов облака, предоставленных командой Wall-E. Предоставляет возможность деплоя инфраструктурных компонент на сервера облака. Поддерживает базовые образы системы, в том числе следит за функционированием стандартных сервисов, таких как sshd или ntpd.

* Конфигурирование системы на хосте: нужно удалить пакеты с dom0, хост не настраивается после переналивки
* Поддержка системных сервисов: ntpd не синхронизирует время на хосте
* Сборка образов, в том числе и для QYP: добавление новых пакетов в стандартный образ

### Системная разработка (SysDev)
[Команда](https://abc.yandex-team.ru/services/infracloudnetwork/duty/) занимается развитием низкоуровневых системных компонент:

* ядра linux, в частности функции изоляции пользовательских сервисов (cpu, memory, io, net)
* porto
* netconfig
* hbf-agent
* dns-cache
* copier

Команда ответственна за конфигурацию сети на серверах облака.

Примеры проблем:

* Изоляция сервисов друг от друга: отсутствие io лимитов, неожиданная с точки зрения пользователя работа cpu limit, пропадание метрик потребляемых контейнерами ресурсов, разъезжается квота томов у сервисов
* Управление контейнерами на хостах, т.е. Porto: Porto в D state
* Настройка сети на хосте: не применяются правила hbf-agent, недоступна сеть внутри контейнеров
* Локальный dns cache, ферма dns-cache.yandex.net: стабильно не резолвятся некоторые адреса
* Проблемы и фичи ядра Linux: процессы в D-state, hung_task в KVM, виртуализация sysctl
* Copier не скачивает файлы

### Golovan
[Команда](https://abc.yandex-team.ru/services/golovan/duty/) ответственна за разработку количественного мониторинга, как серверной части, так и агента. Обычно вопросы прилетают в [GOLOVANSUPPORT](https://st.yandex-team.ru/GOLOVANSUPPORT), поэтому лучше роутить сразу в эту очередь.

За Golovan теперь отвечает команда Solomon.

### Juggler
[Команда](https://abc.yandex-team.ru/services/juggler/duty/) ответственна за разработку событийного мониторинга, как серверной части, так и агента. Обычно вопросы прилетают в [JUGGLERSUPPORT](https://st.yandex-team.ru/JUGGLERSUPPORT), поэтому лучше роутить сразу в эту очередь.

## Проблемы на стыке зон ответственности
Нужно звать дежурных из всех причастных к проблеме сервисов, кто-то из дежурных должен быть назначен координатором. Лучше всего организовать координационный чат если проблема срочная.

## Сроки суппортных тикетов
Саппортные тикеты не должны "подвисать", то есть длиться больше недели. Поэтому имеет смысл добавлять саппортные тикеты в спринт и обрабатывать их соответствующим образом. В том числе при закрытии итерации проходится по саппортным тикетам.

За закрытием саппорта должен следить исполнитель тикета, тимлид же следит за процессом в целом и смотрит что команда не забывает про саппорт.

Данный процесс применим к "обычным" задачам, чья проблема легко трактуется, интерпретируется или workaround заранее известен, так что их можно обработать в рамках рутинной процедуры.

Но иногда возникают непростые ситуации, для них предлагается измененный процесс, описанный в следующем разделе.

### Нетривиальные тикеты
Тикет можно счесть **нетривиальным** - то есть:

* Озвученная проблема еще ни разу не решалась командой
* Невозможно быстро синтезировать адекватный воркераунд
* Предлагаемое решение несет в себе риски для смежных систем и/или долгосрочной разработки / архитектуры / планирования.

В таком случае поспешное принятие решения и раннее озвучивание его клиенту является плохой практикой, ибо в будущем может привести к проблеме "переобувания" (обмана ожиданий клиентов) или трудностей с legacy.

Поэтому, нетривиальные тикеты должны рассматриваться в профильной очереди с повышенным приоритетом и ограниченным сроком.
Исходный суппортный тикет при этом теряет смысл, его можно сразу закрывать в пользу профильного.
В зависимости от сложности проблемы имеет смысл выносить решение на публичное обсуждение путем призыва заинтересованных смежников или архитекторов.

Наличие ограниченного срока рассмотрения и публичного коммитмента для профильного тикета является **обязательным** для адекватного управления ожиданиями клиентов.

## Фичреквесты в саппорте
С фичреквестами, которые приходят из саппорта, нужно поступать следующим образом: заводить тикет в релевантной очереди, закрывая саппортный тикет в пользу него. Саппорт в первую очередь нужен для консультаций и исправления багов. Если баг долгий и сложный - так же лучше перейти в отдельный тикет.
