# Руководство по разметке тикетов в очереди RTCSUPPORT
Под разметкой тикета в данном тексте мы понимаем проставление полей в тикете, таких как:

- Теги
- Компоненты

## Дополнительные теги
**need_dev_review** - тег проставляется в том случае, если задача может быть решена только разработчиком компоненты инфрастуруктуры.
**2_line** - проставить если тикет передается на 2ю линию
**solved_with_document** - проставить если обращение было решено с помощью документации
**need_doc_review** - проставить если требуется доработка/разработка документации

## Инфраструктурный стек
Данная таблица написана, как пример и черновик того как должна выглядеть разметка тикета в очереди RTCSUPPORT.
Тикет должен быт размечен(читай, заполнены поля) следующими полями.
**Area**: Та часть инфраструктуры к которой относиться вопрос/проблема,
**SubArea** _(опционально)_: Если предыдущий тег _(Area)_ описывает довольно общий пласт части инфраструктуры, то _SubArea_ носит уточняющий характер, к примеру уровень _HARDWARE_ может содержать в себе
уровни сетевого оборудования и хост машин.
**Component**: Точная идентификация(чатай метка) проблемы, шаблон имени может быть следущим `<component_name>_<issue_description>`, имя компоненты и краткое(буквально парой слов) описание проблемы.

**Область инфраструктуры** | **Area Tag** | **Описание** | **Компоненты**
--- | --- | ---- | ----
Аппаратное обеспечение | HARDWARE |
Операционная система | OS |
Оркестрация аппартным обеспечением | HARDWARE_ORCHESTRATION | Системы оркестрации/управления аппаратным обеспечением | WALL-E |
 | | | | HWATCHER |
Упревление/оркестрация операционной системой | OS_ORCHESTRATION | Системы оркестрации програмным обеспечением операционной системы | SALT |
 | | | | HOSTMANAGER |
 | | | | SKYNET |
Управление ресурсами | RESOURCE_MANAGEMENT | Системы планирования/управления ресурсами | GENCFG |
 | | | | YP |
Управление доступом | PERMISSIONS | Компоненты отвечающие за сетевые доступы в облаке: puncher, idm, cauth, hbf | HBF |
 | | | | CAUTH |
 | | | | IDM |
 | | | | PUNCHER |
 | | | | ABC |
Сервисные проблемы | SERVICE | Ошибки на стороне сервиса, неверное конфигурирование и т.п. | CONSULTATION |
Системы виртуализации ресурсов | VIRTUALIZATION | Компоненты отвечающие за виртуализацию ресурсов: porto, qyp(kvm over rtc) | PORTO |
 | | | | QYP |
Системы деплоя | DEPLOY | Компоненты отвечающие за деплой сервисов на хост машины облака: ISS, Instancectl | ISS |
 | | | | INSTANCECTL |
Системы управления сервисами | SERVICE_MANAGEMENT | Интерфейсы управления сервисами: Nanny, Qloud, Yandex.Deploy | NANNY |
 | | | | ALEMATE |
 | | | | QLOUD |
 | | | | YDEPLOY |
 | | | | AWACS |
Различный софт | SOFTWARE | | BALANCER |
 | | | | DNS |
 | | | | DOCKER-REGISTRY |
 | | | | DOCKERINFO |
Системы мониторинга | MONITORING | | GOLOVAN |
 | | | | JUGGLER |
Миграция из Qloud в Deploy | SERVICE | Всевозможные вопросы, связанные с миграцией сервисов из Qloud в YDeploy | QloudToYD |


### Аппаратное обеспечение
**Подмножество** | **SubArea Tag** | **Описание** | **Компоненты**
--- | --- | --- | ---
Сетевая инфраструктура | NET | Часть инфраструктуры, отвественная за аппаратное сетевое обесепечение
Аппаратные мощности облака(сервера) | SERVER | Аппаратные мощности облака, хост машины | HARDWARE (Проблемы с аппаратным обеспечением: перегревы, BMC, IPMI, переферийное оборудование)
 | | | | CPU (аппаратные проблемы с процессором)
 | | | | MEMORY (аппаратные проблемы с памятью)
 | | | | DISK

### Операционная система
**Подмножество** | **SubArea Tag** | **Описание** |**Компоненты**
--- | --- | --- | ---
Ядро ОС | KERNEL | Метка для проблем с ядром операционной системы | KERNEL (проблемы с ядром ОС)
Файловая система | FS| Проблемы с файловой системой | FS
Пакетный менеджер| PKG| Проблемы с пакетным менеджером | PKG |
Init | INIT | Проблемы с init системой | INIT |
