# Проблемы IO

## В качестве вступления
В процессе эксплуатации того или иного сервиса, разбработчики и devopsы сталкиваются со множеством проблем и в частности проблем с производительностью. Эта статья попытка собрать знания по поиску и решению проблем с одним из самых критичных ресурсов, а именно ввод/вывод . Статья будет дополняться в том числе и примерами разобраных тикетов.

![hdd-disk](_assets/hdd-disk.600x600.jpg)

## HDD
### Немного теории
#### Устройство HDD
Тут стоит сразу сказать о том, что ресурс, а именно скорость операций на HDD это практически всегда бутылочное горлышко в любой системе. Причина этого - механическая природа устройства и как следствие принцип адресации. И так из чего состоит HDD:

- Spindle(буквально вал на, котором установлены магнитные диски(цилидры))
- Cylinder(магнитные поверхности, цилиндры)
- Track (дорожки, наносятся на цилиндры)
- Sector (далее дорожки делятся на сектора)
- R/W Head

![cylinder-head-sector](_assets/1200px-cylinderheadsector.png)

Далее стоит упомянуть об адресации, адресуются слудующие сущности:

- Номер цилиндра
- Номер дорожки
- Номер сектора(минимальная единица адресации)

Скорость доступа к данным на HDD так же зависит от локализации самих данных, речь тут вот о чем.
Цилиндры HDD это геометрически круг, дорожки которые находяться ближе к центру имееют меньшую длинну соотвественно позиционирование происходит в разы быстрее в отличии от данных, которые находятся дальше от центра окружности.

## Теперь к практике
### Инструменты для диагностики IO
Стоит разделить набор инструментов на 3 категории. Базовые инструменты, дополнительные утилиты.

**Базовые инструменты:**
`iostat` - основной инструмент, который позволяет детально узнать состояние IO в системе
`iotop` - это не совсем базовая утилита(её нет в стандартной наливке ОС), показывает дисковую активность по процессам
`vmstat` - да эта программа в основном для диагностики memusage, но она дает ряд параметров для косвенной диагностики IO
`pidstat -d` - аналог iotop
`lsof`

**Дополнительные утилиты**. Тут список довольно спорный, но выделить можно следующие:
`notify-watch` - это по факту целый пакет для получения данных из подсистемы ядра inotify(отслеживание изменений файлов), позволяет узнать к каким файлам и каталогам идут обращения
`blktrace` - позволяет оценить производительность блочного устройства

### Как определить наличие проблемы
Для определения проблемы с IO достаточно одной утилиты, а именно iostat из пакета sysstat. В стандартной инсталяции серверов Яндекса этот пакет уже установлен, если же доступ на dom0 машину отсутсвует, можно установить данный пакет в контейнер или добавить его в базовый слой. Много дискового пространства для этого не требуется, но сам пакет sysstat содержит довольно мощные утилыты для базовой диагностики ОС.

iostat собирает два типа отчетов, в man странице они обозначены, как стандарный и расширенный, для диагностики нам понадобятся оба.

### iostat стандартный отчет
Весь перевод man страницы iostat тут приводить не будем, поэтому ограничемся описанием только стандартного отчета. Чтобы собрать данный отчет нужно запустить команду со следующими параметрами.

```
iostat -d 1 100
```

В данном случае:
* `-d` - Device utilization report
* `1` - интервал обновления статистики в секундах
* `100` - колличество проб

В итоге получаем вывод следующего вида:

```
Device:            tps    kB_read/s    kB_wrtn/s    kB_read    kB_wrtn
sda             153,54       528,63     19900,63 2163549134 81447818909
nvme0n1           5,56        11,57       755,33   47360670 3091377714
dm-0              6,98         0,70       737,47    2860341 3018251248
dm-1              5,17        11,57       755,33   47355328 3091377714
dm-2              2,29         0,01        17,88      21893   73184284
dm-3            198,84       526,98     19145,30 2156791034 78356453237
```

Device - имя блочного устройства, из них нас интересует именно физические устройства `sda/nvme0n1`, устройства `dm-*` это логические блочные устройства, статистика с них зачастую совпадает с показаниями на физическом устройстве.
tps - transfers per second, фактически число операций в секунду, грубо говоря, это колличество IOPS(операций ввыода вывода)
колонки kB_read/write/s - колличество чтения/записи в секунду, kB_read/wrtn колличетво записанных/прочитанных данных.

Т.к при высоком IO load параметры отчета обновляются довольно быстро, уследить за изменениями показаний и искать проблему глазами довольно трудная задача, по этой причине на стандартный отчет лучше смотреть в виде графика:

{% cut "Пример." %}

![iostat-1](https://jing.yandex-team.ru/files/dvsonin/iostat-1.png)

{% endcut %}

В данном случае мы видим преобладание операций записи над чтением, что может говорить о том, что на сервере есть процессы активно производящие прямую запись на диск, но об этом немного позже.
Чтобы анализировать данный отчет и построенный график, нужно знать следующее:

- Колличество IOPS при последовательных операциях, на которые расчитан диск - у современных HDD это около 350 IOPS
- Колличество IOPS на случайных операциях - у HDD со скоростью вращения 7200 rpm это примерно 170 IOPS
Зная это уже можно сделать вывод, что наш диск перегружен операциями записи уже независимо от типа операции(случайной или последовательной)

### iostat расширенный вывод
Пример команды `iostat -dx 1 100` -x ключ для сбора раширенного вывода, сам вывод выглядит следующим образом.

```
Device:         rrqm/s   wrqm/s     r/s     w/s    rkB/s    wkB/s avgrq-sz avgqu-sz   await r_await w_await  svctm  %util
sda               0,39    67,80    8,26  145,29   528,62 19902,49   266,12     0,78    5,04   30,05    3,62   2,17  33,26
nvme0n1           0,00     0,00    0,44    5,12    11,57   755,32   276,08     0,00    0,42    0,11    0,44   0,02   0,01
dm-0              0,00     0,00    0,02    6,96     0,70   737,59   211,42     0,49   69,44   15,49   69,62  11,18   7,81
dm-1              0,00     0,00    0,44    4,74    11,57   755,32   296,47     0,00    0,14    0,11    0,15   0,02   0,01
dm-2              0,00     0,00    0,00    2,29     0,01    17,88    15,62     0,09   38,73    6,95   38,74  18,94   4,34
dm-3              0,00     0,00    8,76  190,08   526,97 19147,02   197,89     0,18    0,72   33,44    4,73   1,64  32,65
```

Из данного отчета сразу можно сделать вывод о высоком IO load и самая информативная колонка в данном случае это `util`.

{% cut "Пример." %}

![iostat-2](https://jing.yandex-team.ru/files/dvsonin/iostat_x.png)

{% endcut %}

На первом графике и мы можем видеть, что данная метрика в большистве случаев упирается в 100%, что говорит о высокой нагрузке на диск. О возможных причинах высокого IO и как найти источник будет рассмотрено далее.

Графики приведенные в примерах можно получить с помощью скрипта: [iostat_plot](https://arcanum.yandex-team.ru/arc/trunk/arcadia/search/mon/rtc/troubleshooting_tools/bin/iostat_plot).

### Возможные причины высокого IO
#### SYNC файловой сиситемы
sync, sync_fs процесс сброса кеша записи на диск, что приводит к резкому росту IO операций и колличеству данных т.к по сути сброс происходит принудительно в момент вызова. Картина iostat будет выглядеть так:

{% cut "iostat -d" %}

![iostat_sync.png](https://jing.yandex-team.ru/files/dvsonin/iostat_sync.png)

{% endcut %}

{% cut "iostat -dx" %}

![iostat_sync_ex.png](https://jing.yandex-team.ru/files/dvsonin/iostat_sync_ex.png)

{% endcut %}

наблюдаем короткие пики повышения записи и общего колличества IOPS на фоне общей нагрузки, которая к слову сказать не 100%, но около этого. Т.к мы видим в оснвоном операции записи, стоит найти для примера top 5 самый активных по IO процесса и тут естьь несколько способов, как это сделать:

{% cut "iotop" %}

```
 1294 be/3 root        0.00 B/s    7.07 K/s  0.00 %  3.52 % [jbd2/dm-3-8] <--- hdd-place -> ../dm-3
    790 be/3 root        0.00 B/s    0.00 B/s  0.00 %  1.98 % [jbd2/dm-0-8] <--- hdd-root -> ../dm-0
 138966 be/4 loadbase    0.00 B/s  195.47 K/s  0.00 %  1.37 % qemu-system-x86_64 --enable-kvm -cpu host -m 16384M -smp 32 -nographic -nod~7255,script=no -device virtio-net-pci,netdev=qemu_net,mac=52:54:00:12:34:56
   1283 be/3 root        0.00 B/s  803.88 B/s  0.00 %  0.58 % [jbd2/dm-2-8]
```

{% endcut %}

{% cut "pidstat -d с сортировкой по среднему значению" %}

```
dvsonin@vla2-5589:~$ sudo pidstat -d 1 100 | grep Average | grep -v UID | sort -k 5 -nr | head -5
Average:     1049    195917      0,00    175,93      0,44       0  java
Average:     1049    139319     26,23     47,54      0,00       0  qemu-system-x86
Average:     1049      9019      7,04     36,43      0,00       0  qemu-system-x86
Average:     1049    141569      0,00     23,43      0,00       0  qemu-system-x86
Average:     1049    141476      0,00     20,71      0,00       0  qemu-system-x86
```

{% endcut %}

стоит сказать, что iotop и pidstat зачастую расходяться в своих показаниях и для поиска источника(процесса), который создает нагрузку стоит анализировать показания обоих инструментов. В данном случае в iotop мы видим потоки записи журнала jdb2 и qemu машину в pidstat процессы java и виртуальные машины qemu. Складывая вместе картину из iotop, pidstat делаем вывод о том, что внутри одной из виртуальных машин происходит вызов fdatasync т.к данный вызов порождает минимум 2 операции записи: запись непосредственно данных и запись в журнал фс(это мы видим в iotop потоки jdb2).

Проблема в данном случае осложняется тем, что мы не знаем это точно окончательно убедиться в этом нам поможет trace из /sys/kernel/debug, последовательность расследования следующая:

```
echo 1 > /sys/kernel/debug/tracing/events/ext4/ext4_sync_file_enter/enable - включаем trace событий ext4_sync_file_enter
cat /sys/kernel/debug/tracing/trace - далее читаем список событий
```

{% cut "Пример вывода" %}

```
# tracer: nop
#
# entries-in-buffer/entries-written: 252/252   #P:56
#
#                              _-----=> irqs-off
#                             / _----=> need-resched
#                            | / _---=> hardirq/softirq
#                            || / _--=> preempt-depth
#                            ||| /     delay
#           TASK-PID   CPU#  ||||    TIMESTAMP  FUNCTION
#              | |       |   ||||       |         |
           <...>-715121 [002] ...1 5831130.788819: ext4_sync_file_enter: dev 252,3 ino 79691814 parent 79691795 datasync 1
           <...>-715121 [002] ...1 5831130.802538: ext4_sync_file_enter: dev 252,3 ino 79691814 parent 79691795 datasync 1
           <...>-712618 [004] ...1 5831130.948138: ext4_sync_file_enter: dev 252,1 ino 18350103 parent 18350102 datasync 1
           <...>-712617 [006] ...1 5831130.948337: ext4_sync_file_enter: dev 252,1 ino 18350103 parent 18350102 datasync 1
           <...>-710621 [018] ...1 5831131.082507: ext4_sync_file_enter: dev 252,1 ino 18350123 parent 18350122 datasync 1
           <...>-706662 [015] ...1 5831131.082648: ext4_sync_file_enter: dev 252,1 ino 18350123 parent 18350122 datasync 1
           <...>-710466 [000] ...1 5831132.462656: ext4_sync_file_enter: dev 252,3 ino 19398689 parent 19398688 datasync 1
           <...>-706294 [006] ...1 5831132.469565: ext4_sync_file_enter: dev 252,3 ino 19398689 parent 19398688 datasync 1
           <...>-712905 [015] ...1 5831133.527173: ext4_sync_file_enter: dev 252,3 ino 19398663 parent 19398662 datasync 1
           <...>-712909 [014] ...1 5831133.547612: ext4_sync_file_enter: dev 252,3 ino 19398663 parent 19398662 datasync 1
           <...>-714097 [020] ...1 5831133.637361: ext4_sync_file_enter: dev 252,1 ino 120848599 parent 120848598 datasync 1
           <...>-714094 [014] ...1 5831133.637538: ext4_sync_file_enter: dev 252,1 ino 120848599 parent 120848598 datasync 1
```

{% endcut %}

т.к мы знаем устройство(252,3 это major и minor блочного устройства, увидеть их можно в выводе lsblk) на, которое производиться запись отфильтруем собития по этому устройству и отсортируем по процессам/потокам далее попытаемся найти их в /proc и определить cgroup-у:

{% cut "Пример вывода" %}

```
Для начала top 5 самых активных
cat /sys/kernel/debug/tracing/trace | grep 252,3 | awk '{print $1}'| cut -d - -f2| sort | uniq -c | sort -k 1 -nr | head -5
     21 728465
     15 722696
     10 724843
     10 720229
     10 233877
Далее ищем сами процессы и их cgroupы, получается следующий список
cat /sys/kernel/debug/tracing/trace | grep 252,3 | awk '{print $1}'| cut -d - -f2| sort | uniq | while read p ; do printf "$p " [ -d /proc/$p ] && cat /proc/$p/cgroup| grep blkio || printf "\n"; done 2>/dev/null | grep blkio
233877 2:blkio:/skycore/core
767114 2:blkio:/porto%ISS-AGENT--zhestkovb-dev
770273 2:blkio:/porto%ISS-AGENT--zhestkovb-dev
773531 2:blkio:/porto%ISS-AGENT--plus-farm
773542 2:blkio:/porto%ISS-AGENT--plus-farm
773545 2:blkio:/porto%ISS-AGENT--plus-farm
776713 2:blkio:/porto%ISS-AGENT--browser-dev-stasya
776773 2:blkio:/porto%ISS-AGENT--zhestkovb-dev
776779 2:blkio:/porto%ISS-AGENT--zhestkovb-dev
776787 2:blkio:/porto%ISS-AGENT--zhestkovb-dev
776789 2:blkio:/porto%ISS-AGENT--zhestkovb-dev
776837 2:blkio:/porto%ISS-AGENT--plus-farm
776838 2:blkio:/porto%ISS-AGENT--plus-farm
776839 2:blkio:/porto%ISS-AGENT--plus-farm
776840 2:blkio:/porto%ISS-AGENT--plus-farm
776841 2:blkio:/porto%ISS-AGENT--plus-farm
776958 2:blkio:/porto%ISS-AGENT--fadeich
776960 2:blkio:/porto%ISS-AGENT--fadeich
```

{% endcut %}

видим, что преимущественно это виртуальные машины, а значит далее нужно искать источник уже внутри самих ВМ. Фактически проверка каждой ВМ сводиться к повторению тех же действий:

- iostat
- iotop/pidstat
- просмотр эвентов ext4
но уже внутри каждой вм, не будем повторяться и забежим немного вперед. Источник проблем в данном случае это ВМ `ISS-AGENT--browser-dev-stasya` и процесс mongodb который как раз и вызывал datasync при падении демона(для сохранения логов). Увидеть sync вызовы можно уже из strace процесса выглядят они следующим образом:

{% cut "Пример вывода" %}

```
[pid 239951] fdatasync(12 <unfinished ...>
[pid 239969] fdatasync(13)              = 0
[pid 239951] <... fdatasync resumed> )  = 0
[pid 239969] fdatasync(13 <unfinished ...>
[pid 239951] fdatasync(14)              = 0
[pid 239969] <... fdatasync resumed> )  = 0
[pid 239951] fdatasync(13 <unfinished ...>
[pid 239969] fdatasync(14 <unfinished ...>
[pid 239951] <... fdatasync resumed> )  = 0
[pid 239951] fdatasync(12 <unfinished ...>
[pid 239969] <... fdatasync resumed> )  = 0
[pid 239969] fdatasync(14 <unfinished ...>
[pid 239951] <... fdatasync resumed> )  = 0
Process 239970 attached
Process 239971 attached
Process 239972 attached
Process 239973 attached
[pid 239951] fdatasync(12 <unfinished ...>
[pid 239969] <... fdatasync resumed> )  = 0
[pid 239951] <... fdatasync resumed> )  = 0
Process 239973 detached
Process 239971 detached
[pid 239972] fdatasync(16)              = 0
[pid 239972] fdatasync(15)              = 0
[pid 239972] fdatasync(16)              = 0
[pid 239972] fdatasync(15)              = 0
[pid 239972] fdatasync(10)              = 0
[pid 239972] fdatasync(14)              = 0
[pid 239972] fdatasync(14)              = 0
[pid 239972] fdatasync(10)              = 0
[pid 239972] fdatasync(12)              = 0
Process 239972 detached
Process 239970 detached
[pid 239951] fdatasync(12)              = 0
Process 239969 detached
Process 239967 detached
Process 239968 detached
[pid 239951] fdatasync(12)              = 0
[pid 239951] fdatasync(11)              = 0
Process 239951 detached
```

{% endcut %}

После отключения процесса mongo внутри ВМ, картина с iostat выглядит так:

{% cut "Пример" %}

![iostat_sync_after.png](https://jing.yandex-team.ru/files/dvsonin/iostat_sync_after.png)

{% endcut %}

пиковые значения остались, но в меньшем колличестве(помним, что там была не одна ВМ), общее колличество операций уменьшилось.

#### Высокая активность jdb2
jdb - часть ядра linux, отвечающая за ведение журнала изменений файловой системы.

{% cut "Немного о журналировании" %}

Журнал - по сути это кольцевой буфер в который заносяться данные связанные с изменением файловой системы. В первую очередь журналирование предназначено для защиты файловой системы от сбоев, как альтернатива процедуре fsck. Переодически изменения записанные в журнал применяются к файловой системе. В случае сбоя журнал FS может использоваться в качестве отправной точки в попытке востановления не сохраненных данных и поврежденных метаданных. Небольшая иллюстрация к процессу:
![journal.gif](_assets/journal.gif)

{% endcut %}

Стоит сказать, что высокая активность процесса журналирования может быть следствием других причин, например syncfs из предыдущего раздела, но установить настоящую причину вначале не всегда возможно, зачастую нам доступен только факт наличия высокой активности jdb и данные iostat, которые уже в процессе можно связать с поределенным процессом.

{% cut "Параметры FS связанные с журналом" %}
Не смотря на то, что эти параметры в 99% случаев одинаковы, все же для общего развития их стоит упомянуть.

**Определяем, что журнал для FS ведется**
Для этого нам нужна команда dumpe2fs

```
dumpe2fs -h /dev/<тут нужно указать раздел с файловой системой>
```
из полученного вывода нас итересует строка

```
Filesystem features:      has_journal ext_attr resize_inode dir_index filetype needs_recovery extent flex_bg sparse_super large_file huge_file uninit_bg dir_nlink extra_isize
```
о факте ведения журнала для данного раздела говорит наличие опции `has_journal`

**Режим ведения журнала**
из того же вывода dumpe2fs мы можем получить режим в котором ведется журнал

```
Journal features:         journal_incompat_revoke
```
это и есть режим в котором ведется журнал, всего для ext4 есть 3 режима:

**writeback** - файловая система не производит журналирования.
**ordered** - файловая система журналирует только метаданные
**journal** - полное жруналирование метаданных(этот тип кака раз соотвествует выводу dumpe2fs `journal_incompat_revoke`

по производительности самый быстрый режим writeback, самый медленный journal т.к фактически мы записываем данные 2 раза, ordered показывает средние значения.

{% endcut %}

{% cut "Этапы записи журнала" %}

Запись журнала производится транзакциями, которые проходят следующие состояния:
Running - Транзакция запущена и принимает дескрипторы
Locked - не принимает новые дескрипторы, но старые еще не заверщены
Flush - транзакция завершена и записывается в журнал
Commit - транзакция завершена и изменения записываются на диск
Finished - транзакция заверщена, записана в журнал и на устройство. Может быть удалена из журнала.

{% endcut %}

Для примера возьмем вывод pidstat,

```
Average:      367    355957      0,00   7090,52   1312,40       0  publisher.pl
Average:        0    240456      0,00   8852,00      0,00       0  yabs-bscount
Average:        0      1415      0,00 346925,39      0,00      75  jbd2/dm-3-8
```
тут видно, что в top именно jdb2, из этого же вывода можно определить для какого раздела происходит запись журнала `dm-3-8`
Интерпритировать имя dm устройства в раздел можно через /proc

```
dvsonin@man1-3230:~$ ls -l /dev/mapper/
total 0
crw------- 1 root root 10, 236 Dec 28 03:00 control
lrwxrwxrwx 1 root root       7 Feb  5 13:04 hdd-home -> ../dm-2
lrwxrwxrwx 1 root root       7 Feb  5 13:04 hdd-place -> ../dm-3
lrwxrwxrwx 1 root root       7 Feb  5 13:04 hdd-root -> ../dm-0
lrwxrwxrwx 1 root root       7 Feb  5 13:04 nvme-ssd -> ../dm-1
```

Тут мы увы видим только факт, что jdb2 активно трогает диск(помним, что журнал пишеться именно на диск) поэтому, чтобы найти процесс, который порождает запись в журнал нужно пределить тот самый файл для которого применяются изменения. Для этого воспользуемся все той же подсистемой `/sys/kernel/debug`, а именно `/sys/kernel/debug/tracing/events/jbd2/jbd2_submit_inode_data`

вывод trace выглядит так:

```
     jbd2/dm-3-8-1415  [050] ...1 4460639.493167: jbd2_submit_inode_data: dev 252,3 ino 61866867
     jbd2/dm-3-8-1415  [000] ...1 4460639.670686: jbd2_submit_inode_data: dev 252,3 ino 49545849
     jbd2/dm-3-8-1415  [000] ...1 4460639.670688: jbd2_submit_inode_data: dev 252,3 ino 293797970
     jbd2/dm-3-8-1415  [000] ...1 4460639.670689: jbd2_submit_inode_data: dev 252,3 ino 293798079
     jbd2/dm-3-8-1415  [000] ...1 4460639.670689: jbd2_submit_inode_data: dev 252,3 ino 293797961
     jbd2/dm-3-8-1415  [028] ...1 4460639.716692: jbd2_submit_inode_data: dev 252,3 ino 61866862
     jbd2/dm-3-8-1415  [021] ...1 4460639.736647: jbd2_submit_inode_data: dev 252,3 ino 61866862
```

нужная нам информация это inode number по которому и можно установить файл. Так же отсюда можно установить наиболее часто изменяемый файл.
Найти файлы по номеру inode можно следующим образом:

```
cat /sys/kernel/debug/tracing/trace | grep dm-3-8 | grep jbd2_submit_inode_data | awk '{print $NF}'| sort | uniq -c | sort -rn -k1 | head -1 | awk '{print $NF}' | xargs -I {} find /place -inum {}
```

Результатом будет список имен файлов на которые ссылается inode

{% cut "Выглядит это так" %}

```
/place/porto_volumes/37/volume/statbox/stats/logbroker/state-bdb/log.0000001053
/place/db/iss3/volumes/music-stable-back-man-9-kzpq6qrknd5sh4pz/statbox/stats/logbroker/state-bdb/log.0000001053
/place/db/iss3/volumes/ISS-AGENT_7dP1MOjuv5H/var/log/statbox/stats/logbroker/state-bdb/log.0000001053
/place/db/iss3/volumes/ISS-AGENT_KmNBvsuIWBB/var/log/statbox/stats/logbroker/state-bdb/log.0000001053
/place/db/iss3/volumes/ISS-AGENT_ygb4qskG72O/var/log/statbox/stats/logbroker/state-bdb/log.0000001053
/place/porto_storage/ISS-AGENT--music-stable-back-man-9-kzpq6qrknd5sh4pz/statbox/stats/logbroker/state-bdb/log.0000001053
```
если применить stat к данным файлам, мы увидим, что номер inode у них совпадает.

{% endcut %}
