# Системы деплоя (ISS)
## Сброс к начальному состоянию агента {#reinit_iss}
**Пожалуйста, не используйте это, если у вас нет соответствующих прав или вы не в полной мере понимаете, к чему может привести такая операция.**
Бывает так, что ISS-агент теряет файлы статуса (`/iss3/state3`, `/iss3/state3.backup`) - например, если в `/` кончилось место. В этом случае агент не может восстановить статус и не хочет синхронизироваться. В этом случае агенту можно задать маркер первого запуска и перезапустить - это заставит агент заново установить статус.
```bash
$ sudo touch /db/iss3/_initial_start_marker
$ sudo service yandex-iss-agent restart
```

## Очистка очереди установок {#iss_drop_install_queue}
**Пожалуйста, не используйте это, если у вас нет соответствующих прав или вы не в полной мере понимаете, к чему может привести такая операция.**
В некоторых случаях установки в очереди агента залипают (чаще это случается с шардовыми сервисами).
Очередь установок можно посмотреть командой `curl -s localhost:25536/scheduler/install/queue`.
Если видно, что установки застряли, можно увеличить лимит одновременно выполняемых установок вызовом `curl -s localhost:25536/scheduler/install/window/${new_size}`, где new_size - новое количество разрешённых к одновременному выполнению операций установки.
Также можно очистить очередь установки с помощью  `curl -s localhost:25536/scheduler/install/clear` - через некоторое время очередь перестроится.

## Очистка очереди загрузок {#iss_drop_dl_queue}
**Пожалуйста, не используйте это, если у вас нет соответствующих прав или вы не в полной мере понимаете, к чему может привести такая операция.**
В некоторых случаях установки в очереди агента залипают (чаще это случается с шаровыми сервисами).
Очередь загрузок можно посмотреть командой `curl -s localhost:25536/scheduler/downloads/queue`.
Если видно, что загрузки застряли, можно увеличить лимит одновременно выполняемых загрузок вызовом `curl -s localhost:25536/scheduler/downloads/window/${new_size}`, где new_size - новое количество разрешённых к одновременному выполнению операций загрузки.
Также можно очистить очередь загрузок с помощью `curl -s localhost:25536/scheduler/downloads/clear` - через некоторое время очередь перестроится.

## Проверка ограничений на шарды {#shards_constraints_check}
В случае, если на один хост нужно установить один и тот же шард для разных сервисов, может возникнуть проблема при наличии различающихся ограничений на шарды.
Проверить это можно запросами к локальному ISS-агенту:

```bash
#!/bin/bash
host="${1}"
service_name="${2}"
conf_id=${3}
shard_name="$(curl -s "${host}":25536/v1/instances | jq -r '. | map(select(.configurationId.id == "'"${service_name}"'-'"${conf_id}"'"))[0].entityDescription | .properties.shard_name')"
curl -s "${host}":25536/v1/instances | jq '. | map(select(.configurationId.id == "'"${service_name}"'-'"${conf_id}"'"))[0].entityDescription.resources | map(select(.shardId == "'"${shard_name}"'"))[0]'
curl -s "${host}":25536/v1/instances | jq '. | map(select( (.entityDescription.resources  | map(select(.shardId == "'"${shard_name}"'")) | length) > 0)) | map ({"id": .configurationId.id, "slot": .slot.service, "constraints": .entityDescription.resources | map(select(.shardId == "'"${shard_name}"'"))[0].container.constraints})'
```
Добавление этого функционала в wabbajack идёт в RTCSUPPORTTOOLS-7

## Проблемы с контейнеризованной закачкой {#shards_constraints_check}
В рамках ISS-6388 идёт включение контейнеризованного копира. К сожалению, есть ошибка, которая должна быть исправлена в 3.5.3950.0
Вот простой скрипт для проверки:

```bash
[ 1 -eq "$(curl -s localhost:25536/version | jq -r '.version' | awk -F '.' '{if (( $1 <= 3 ) && ($2 <= 5) && ($3 <= 3950)) print 1; else print 0}')" ] && [ 'atrue' = "a$(cat /place/db/iss3/application.conf | jq -r '.agent.fetcher.containerized.copier_containerized')" ] && echo "Erroneous copier containerization" || echo "Seems that it is not known error"
```
Собственно, единственный вариант исправления до выкатки 3.5.3950 - локальное отключение настройки.
Для этого нужно отключить salt, изменить в /place/db/iss3/application.conf настройку `copier_containerized` на false и перезапустить iss-agent.
Это даст возможность ресурсу скачаться. Не забудьте после успешной закачки ресурса включить salt обратно.
У контейнера с закачкой должен быть проставлен label `res.id` (`portoctl get ${container} labels`).
В ISS-6405 описаны ручки, по которым можно будет поматчить ресурс:

1. `resources/find/label/:label` - найти ресурс по лейблу, проставленному на контейнер закачки
1. `resources/find/id/:resourceId` - найти ресурс по id ресурса (хэш по полям) [айдишник ресурса в очереди]
1. `resources/find/uuid/:uuid` - найти ресурс по uuid ресурса
1. `resources/instances/:resourceId` - найти все инстансы, который владеют ресурсом с таким id (см. ручку 2)

## Агент умирает по ООМу {#iss-agent-oom}
В dmesg должны быть сответсвующие сообщения, если он убивается OOM'ом в porto, или сообщение в MotD и запись в логе /db/iss3/oom.log, если прибивается jvm.
Обычно агента пришибает через минуту после старта, когда он стартует копир или sky files для докачки/проверки ресурсов.
То есть агенту нужно поднять лимиты помогая пережить бёрсты.
Файлы из которых берутся лимиты:

1. `/db/iss3/iss-agent.vmoptions` с лимитами jvm (-Xmx, -Xss, -XX:MetaspaceSize, -XX:MaxMetaspaceSize, -XX:ReservedCodeCacheSize)
1. `/db/iss3/porto.options` с лимитами для контенера (anon_limit, memory_limit)

В porto.options последнее вхождение значения перекрывает остальные.
Если в dmesg есть сообщения про ООМы то нужно поднимать memory_limit и anon_limit.

1. Останавливаем Солт (!**Не забудьте откатить изменения в кронячке**).

- Комментим кронячку

```
sudo sed -i 's/^/#/' /etc/cron.d/yandex-search-salt
```
- Пристрелим солт

```
sudo pkill -9 salt
```
2. Выставить новые значения в нужных агентских файлах
2. Порестартить агента

```
sudo restart yandex-iss-agent
```
4. Подождать пока агент разберётся с ресурсами и копирами (От 30 минут до полутора часов)
4. Вернуть кронячку обратно

```
sudo sed -i 's/^#//' /etc/cron.d/yandex-search-salt
```

## Не поднимается конфигурация на хосте. {#iss-provider}
Одной из причин того, что на хост не приезжает конфигурация сервиса, может быть отсутствие в конфиге iss соответствующего провайдера. Например, если в конфиге `/db/iss3/application.conf` стоит ```"providersNumber": 0```, то это означает, что на хосте не включен провайдер gencfg. Т.е. на такой хост gencfg-сервис не приедет. За включение yp-провайдера отвечает секция `ypProvider`.
