#!/usr/bin/env python
# -*- coding: utf-8 -*-

import argparse
import logging

from utils import init_root_logger, run_updater
from update_alerts import AlertsUpdater
from update_panels import PanelsUpdater
from update_trees import TreesUpdater

log = logging.getLogger(__name__)


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('--dry-run', action='store_true', default=False)
    return parser.parse_args()


if __name__ == '__main__':
    args = parse_args()

    init_root_logger()
    for updater_class in (AlertsUpdater, PanelsUpdater, TreesUpdater):
        run_updater(updater_class(dry_run=args.dry_run), log)
