# -*- coding: utf-8 -*-


class MonitoringUpdaterBaseError(Exception):
    pass


class MonitoringUpdaterNonExistentPath(MonitoringUpdaterBaseError):
    pass


class MonitoringUpdaterHttpError(MonitoringUpdaterBaseError):
    def __init__(self, message, error, traceback, url, status_code):
        super(MonitoringUpdaterHttpError, self).__init__(message)
        self.error = error
        self.traceback = traceback
        self.url = url
        self.status_code = status_code


class TreesUpdaterError(MonitoringUpdaterBaseError):
    pass


class PanelsUpdaterError(MonitoringUpdaterBaseError):
    pass


class AlertsUpdaterError(MonitoringUpdaterBaseError):
    pass
