package deploy

import ()

var deployDomainNames = map[string]string{
	"test": "test.deploy.yandex-team.ru",
	"pre":  "man-pre.deploy.yandex-team.ru",
	"":     "deploy.yandex-team.ru",
}

var deployClusterNames = map[string]string{
	"YP_SAS_TEST": "sas-test",
	"YP_MAN_PRE":  "man-pre",
	"YP_IVA":      "iva",
	"YP_MAN":      "man",
	"YP_MYT":      "myt",
	"YP_SAS":      "sas",
	"YP_VLA":      "vla",
}

func GetDomainName(environ string) string {
	name, ok := deployDomainNames[environ]
	if !ok {
		return deployDomainNames[""]
	}
	return name
}

func GetClusterName(cluster string) string {
	name, ok := deployClusterNames[cluster]
	if !ok {
		return "none"
	}
	return name
}
