package deploy

import (
	"fmt"
	"sync"

	pb "a.yandex-team.ru/infra/rtc/instance_resolver/api"
)

type DeployState struct {
	mutex             sync.Mutex
	deployUnits       []*pb.TDeployDU
	failedDeployUnits map[string]string
	seenDeployUnits   map[string]bool
}

func NewDeployState() (state *DeployState) {
	state = &DeployState{
		deployUnits:       make([]*pb.TDeployDU, 0),
		failedDeployUnits: make(map[string]string),
		seenDeployUnits:   make(map[string]bool),
	}
	return
}

func (s *DeployState) getKey(stageID string, deployUnitID string) string {
	return fmt.Sprintf(`%s.%s`, stageID, deployUnitID)
}

func (s *DeployState) IsSeen(stageID string, deployUnitID string) bool {
	s.mutex.Lock()
	defer s.mutex.Unlock()
	key := s.getKey(stageID, deployUnitID)
	_, seen := s.seenDeployUnits[key]
	if !seen {
		s.seenDeployUnits[key] = true
	}
	return seen
}

func (s *DeployState) SetError(stageID string, deployUnitID string, err error) {
	s.mutex.Lock()
	defer s.mutex.Unlock()
	key := s.getKey(stageID, deployUnitID)
	s.failedDeployUnits[key] = err.Error()
}

func (s *DeployState) Append(deployUnit *pb.TDeployDU) {
	s.mutex.Lock()
	defer s.mutex.Unlock()
	s.deployUnits = append(s.deployUnits, deployUnit)
}

func (s *DeployState) GetDeployUnits() []*pb.TDeployDU {
	s.mutex.Lock()
	defer s.mutex.Unlock()
	return s.deployUnits
}

func (s *DeployState) GetFailedDeployUnits() map[string]string {
	s.mutex.Lock()
	defer s.mutex.Unlock()
	return s.failedDeployUnits
}
