package golovan

import (
	"fmt"
	"time"

	"a.yandex-team.ru/infra/rtc/instance_resolver/pkg/freshcache"
)

type CacheDriver struct {
	client *GolovanClient
}

func (c *CacheDriver) Stop() {
	c.client.cancel()
}

func (c *CacheDriver) GetCache() interface{} {
	return c.client
}

func (c *CacheDriver) Update() error {
	_, err := c.client.updateItypeMap()
	return err
}

func (c *CacheDriver) LoadState(path string) error {
	golovanItypeMap, err := c.client.loadItypeMap(path)
	if err != nil {
		return err
	}
	c.client.itypeMap = golovanItypeMap
	return nil
}

func (c *CacheDriver) DumpState(path string) error {
	if c.client.itypeMap == nil {
		return fmt.Errorf("golovan cache not initialized")
	}
	return c.client.dumpItypeMap(c.client.itypeMap, path)
}

func (c *CacheDriver) GetAge() time.Duration {
	if c.client.itypeMap == nil {
		return time.Duration(0)
	}
	return time.Since(c.client.itypeMap.Timestamp)
}

func (c *CacheDriver) GetOptions() freshcache.CacheDriverOptions {
	return freshcache.CacheDriverOptions{
		Name:        "golovan",
		RefreshTime: 15 * time.Minute,
	}
}

func NewCacheDriver(client *GolovanClient) *CacheDriver {
	return &CacheDriver{client: client}
}
