package iss3

type IssCacherAddr struct {
	Host   string
	Port   int
	Origin string
}

var issCachersPerOrigin = map[string]IssCacherAddr{
	"ISS_MULTI": IssCacherAddr{"iss3.yandex-team.ru", 9090, "ISS_MULTI"},
	"ISS_SAS":   IssCacherAddr{"iss3sas.yandex-team.ru", 9090, "ISS_SAS"},
	"ISS_MAN":   IssCacherAddr{"iss3man.yandex-team.ru", 9090, "ISS_MAN"},
	"ISS_VLA":   IssCacherAddr{"iss3vla.search.yandex.net", 9090, "ISS_VLA"},
	"ISS_MSK":   IssCacherAddr{"iss3msk.yandex-team.ru", 9090, "ISS_MSK"},
	"ISS_ADM":   IssCacherAddr{"iss3-adm.yandex-team.ru", 9090, "ISS_ADM"},
}

func GetIssCacherAddr(origin string) (*IssCacherAddr, bool) {
	if cacher, ok := issCachersPerOrigin[origin]; ok {
		return &cacher, true
	} else {
		return nil, false
	}
}
