package iss3

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestNotExistCacher(t *testing.T) {
	cacher, ok := GetIssCacherAddr("ISS_NOT_EXISTS")
	assert.False(t, ok)
	assert.Nil(t, cacher)
}

func TestAdmCacher(t *testing.T) {
	cacher, ok := GetIssCacherAddr("ISS_ADM")
	assert.True(t, ok)
	assert.Equal(t, *cacher, IssCacherAddr{"iss3-adm.yandex-team.ru", 9090, "ISS_ADM"})
}
