package nanny

import (
	"sync"

	pb "a.yandex-team.ru/infra/rtc/instance_resolver/api"
)

type NannyState struct {
	mutex          sync.Mutex
	services       []*pb.TNannyService
	failedServices map[string]string
	seenServices   map[string]bool
}

func NewNannyState() (state *NannyState) {
	state = &NannyState{
		services:       make([]*pb.TNannyService, 0),
		failedServices: make(map[string]string),
		seenServices:   make(map[string]bool),
	}
	return
}

func (s *NannyState) IsSeen(serviceID string) bool {
	s.mutex.Lock()
	defer s.mutex.Unlock()
	_, seen := s.seenServices[serviceID]
	if !seen {
		s.seenServices[serviceID] = true
	}
	return seen
}

func (s *NannyState) SetError(serviceID string, err error) {
	s.mutex.Lock()
	defer s.mutex.Unlock()
	s.failedServices[serviceID] = err.Error()
}

func (s *NannyState) Append(service *pb.TNannyService) {
	s.mutex.Lock()
	defer s.mutex.Unlock()
	s.services = append(s.services, service)
}

func (s *NannyState) GetServices() []*pb.TNannyService {
	s.mutex.Lock()
	defer s.mutex.Unlock()
	return s.services
}

func (s *NannyState) GetFailedServices() map[string]string {
	s.mutex.Lock()
	defer s.mutex.Unlock()
	return s.failedServices
}
