package qloud

import (
	"encoding/json"
)

type ACL struct {
	ObjectID   string `json:"objectId"`
	ACEs       []ACE  `json:"acls"`
	ObjectName string `json:"objectName"`
}

type ACE struct {
	GrantedObjectID    string `json:"grantedObjectId"`
	User               string `json:"user"`
	Permission         string `json:"permission"`
	Admin              bool   `json:"admin"`
	Type               string `json:"type"`
	ID                 int    `json:"id"`
	RoleID             int    `json:"roleId"`
	GrantedObjectLevel string `json:"grantedObjectLevel"`
	GrantedObjectName  string `json:"grantedObjectName"`
}

func decodeACL(aclJSON []byte) (*ACL, error) {
	var acl ACL
	err := json.Unmarshal(aclJSON, &acl)
	if err != nil {
		return nil, err
	}

	return &acl, nil
}
