package qloud

import (
	"fmt"
	"strings"
)

type Environment struct {
	Project     string
	Application string
	Environment string
	Component   string
	Segment     string
	dnsSD       string
}

func NewEnvironmentFromDNSSD(dnsSD string) (*Environment, error) {
	matches := strings.SplitN(dnsSD, ".", 6)

	if len(matches) != 6 {
		return nil, fmt.Errorf("cannot parse qloud DNS-SD string: %s", dnsSD)
	}

	return &Environment{
		Component:   matches[0],
		Environment: matches[1],
		Application: matches[2],
		Project:     matches[3],
		Segment:     GetSegmentFromDNSSDSegment(matches[4]),
		dnsSD:       dnsSD,
	}, nil
}

func (e *Environment) GetURL() string {
	return fmt.Sprintf("https://%s.yandex-team.ru/projects/%s/%s/%s/%s/view", e.Segment, e.Project, e.Application, e.Environment, e.Component)
}

func (e *Environment) String() string {
	return e.dnsSD
}
