package qloud

import (
	"sync"

	pb "a.yandex-team.ru/infra/rtc/instance_resolver/api"
)

type QloudState struct {
	mutex              sync.Mutex
	environments       []*pb.TQloudEnvironment
	failedEnvironments map[string]string
	seenEnvironments   map[string]bool
}

func NewQloudState() *QloudState {
	state := &QloudState{
		environments:       make([]*pb.TQloudEnvironment, 0),
		failedEnvironments: make(map[string]string),
		seenEnvironments:   make(map[string]bool),
	}
	return state
}

func (s *QloudState) IsSeen(dnsSD string) bool {
	s.mutex.Lock()
	defer s.mutex.Unlock()
	_, seen := s.seenEnvironments[dnsSD]
	if !seen {
		s.seenEnvironments[dnsSD] = true
	}
	return seen
}

func (s *QloudState) SetError(dnsSD string, err error) {
	s.mutex.Lock()
	defer s.mutex.Unlock()
	s.failedEnvironments[dnsSD] = err.Error()
}

func (s *QloudState) Append(env *pb.TQloudEnvironment) {
	s.mutex.Lock()
	defer s.mutex.Unlock()
	s.environments = append(s.environments, env)
}

func (s *QloudState) GetEnvironments() []*pb.TQloudEnvironment {
	s.mutex.Lock()
	defer s.mutex.Unlock()
	return s.environments
}

func (s *QloudState) GetFailedEnvironments() map[string]string {
	s.mutex.Lock()
	defer s.mutex.Unlock()
	return s.failedEnvironments
}
