package qyp

import (
	"sync"

	pb "a.yandex-team.ru/infra/rtc/instance_resolver/api"
)

type QypState struct {
	mutex     sync.Mutex
	vms       []*pb.TQypVM
	failedVMs map[string]string
	seenVMs   map[string]bool
}

func NewQypState() (state *QypState) {
	state = &QypState{
		vms:       make([]*pb.TQypVM, 0),
		failedVMs: make(map[string]string),
		seenVMs:   make(map[string]bool),
	}
	return
}

func (s *QypState) IsSeen(vmID string) bool {
	s.mutex.Lock()
	defer s.mutex.Unlock()
	_, seen := s.seenVMs[vmID]
	if !seen {
		s.seenVMs[vmID] = true
	}
	return seen
}

func (s *QypState) SetError(vmID string, err error) {
	s.mutex.Lock()
	defer s.mutex.Unlock()
	s.failedVMs[vmID] = err.Error()
}

func (s *QypState) Append(vm *pb.TQypVM) {
	s.mutex.Lock()
	defer s.mutex.Unlock()
	s.vms = append(s.vms, vm)
}

func (s *QypState) GetVMs() []*pb.TQypVM {
	s.mutex.Lock()
	defer s.mutex.Unlock()
	return s.vms
}

func (s *QypState) GetFailedVMs() map[string]string {
	s.mutex.Lock()
	defer s.mutex.Unlock()
	return s.failedVMs
}
